package com.xforceplus.api.tenant.org.virtual;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.domain.orgVirtual.OrgVirtualNodeDTO;
import com.xforceplus.domain.user.UserDto;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@SuppressWarnings("all")
public interface OrgVirtualNodeApi {


    @ResponseBody
    @RequestMapping(name = "当前租户下的新增组织树", value = Path.CREATE, method = RequestMethod.POST)
    <O extends OrgVirtualNodeDTO> ResponseEntity<O> tenantCreate(@PathVariable("tenantKey") String tenantKey,
                                                                 @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                 @PathVariable(value = "typeId") Long typeId,
                                                                 @PathVariable(value = "orgVirtualId") Long orgVirtualId);

    @ResponseBody
    @RequestMapping(name = "当前租户下的追加组织树", value = Path.APPEND, method = RequestMethod.POST)
    <O extends OrgVirtualNodeDTO> ResponseEntity<O> tenantAppend(@PathVariable("tenantKey") String tenantKey,
                                                                 @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                 @RequestBody @Valid OrgVirtualNodeModel.Request.Append append);


    @ResponseBody
    @RequestMapping(name = "虚拟组织树绑定用户(可标识管理员)", value = Path.BINDED_ADMINISTRATOR, method = RequestMethod.POST)
    ResponseEntity<String> batchBindUserAndAdmin(@PathVariable(value = "typeId") Long typeId,
                                                 @PathVariable("nodeId") Long nodeId, @PathVariable("tenantKey") String tenantKey,
                                                 @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                 @RequestBody OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo);


    @ResponseBody
    @RequestMapping(name = "查询指定组织节点管理员列表", value = Path.BINDED_ADMINISTRATOR, method = RequestMethod.GET)
    <U extends UserDto> ResponseEntity<List<U>> queryUserInfoOfNode(@PathVariable("tenantKey") String tenantKey,
                                                                    @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                    @PathVariable("nodeId") Long virtualNodeId,
                                                                    @RequestParam(value = "byNodeId", required = true) Boolean byNodeId,
                                                                    @PathVariable(value = "typeId") Long typeId,
                                                                    @RequestParam(value = "adminFlag", required = false) Integer adminFlag);

    @ResponseBody
    @RequestMapping(name = "查询指定租户下的虚拟组织树（平铺分页）", value = Path.PAGE, method = RequestMethod.GET)
    <O extends OrgVirtualNodeDTO> ResponseEntity<Page<O>> tenantVirtualTreePage(@PathVariable(value = "typeId") Long typeId, @SpringQueryMap OrgVirtualNodeModel.Request.Query query, Pageable pageable, @PathVariable("tenantKey") String tenantKey, @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode);


    @ResponseBody
    @RequestMapping(name = "删除组织", value = Path.DELETE, method = RequestMethod.DELETE)
    ResponseEntity<String> tenantDelete(@PathVariable("tenantKey") String tenantKey,
                                        @PathVariable("id") Long id,
                                        @PathVariable("typeId") Long typeId,
                                        @RequestParam(value = "userId", required = false) Long userId,
                                        @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                        @RequestParam(value = "operationType", required = true) Integer operationType);

    interface Path extends Uri {
        String CUSTOM_PATH_PREFIX = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION;
        String CREATE = CUSTOM_PATH_PREFIX + "/org-virtuals/tree/{typeId}/{orgVirtualId}";
        String APPEND = CUSTOM_PATH_PREFIX + "/org-virtuals/tree";

        String PAGE = CUSTOM_PATH_PREFIX + "/org-virtuals/tree/page/{typeId}";
        /**
         * 节点 组织 关系删除地址
         */
        String DELETE = CUSTOM_PATH_PREFIX + "/org-virtuals/tree/{typeId}/{id}";

        /**
         * 查找nodeId节点下的管理员列表
         */
        String BINDED_ADMINISTRATOR = CUSTOM_PATH_PREFIX + "/org-virtuals/{typeId}/{nodeId}/admins";

    }
}
