package com.xforceplus.api.tenant.org.virtual;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request;
import com.xforceplus.domain.orgVirtual.OrgVirtualOrgStructDTO;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;


/**
 * 业务组织关联行政组织相关接口 (tenant)
 *
 * @author zhouxin
 */
@SuppressWarnings("all")
public interface OrgVirtualOrgStructRelApi {

    /**
     * 业务组织关联的行政组织分页列表
     */
    @ResponseBody
    @RequestMapping(name = "业务组织关联的行政组织分页列表", value = Path.PAGE, method = RequestMethod.GET)
    <T extends OrgVirtualOrgStructDTO> ResponseEntity<Page<T>> page(@PathVariable("tenantKey") String tenantKey,
                                                                    @SpringQueryMap Request.Query query, Pageable pageable);

    /**
     * 新增业务组织关联行政组织
     */
    @ResponseBody
    @RequestMapping(name = "业务组织关联行政组织", value = Path.RELATE, method = RequestMethod.POST)
    ResponseEntity<Boolean> relate(@PathVariable("tenantKey") String tenantKey,
                                   @RequestBody Request.Relate model);


    @SuppressWarnings("all")
    interface Path extends Uri {

        String CUSTOM_PATH_PREFIX = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION;

        String PREFIX = CUSTOM_PATH_PREFIX + "/orgvirtual-orgstructs";
        String PAGE = PREFIX;
        String RELATE = PREFIX + "/relate";
        String BATCH_EXPORT = PREFIX + "/orgvirtual-orgstructs/export";
        String IMPORT = PREFIX + "/orgvirtual-orgstructs/import";
    }

}
