package com.xforceplus.api.tenant.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourcesetModel.Request.Query;
import com.xforceplus.domain.resource.ResourcesetDto;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 功能集相关接口 (global)
 *
 * @author geewit
 */
public interface ResourceSetApi {
    /**
     * 功能集分页列表
     *
     * @param tenantId 租户ID
     * @param query    查询
     * @param pageable 分页对象
     * @return ResourcesetDto
     */
    @ResponseBody
    @RequestMapping(name = "功能集分页列表", value = Path.PAGE, method = RequestMethod.GET)
    <T extends ResourcesetDto> ResponseEntity<Page<T>> page(@PathVariable("tenantId") @Valid @Min(1) Long tenantId,
                                                            @SpringQueryMap Query query,
                                                            Pageable pageable);

    @SuppressWarnings("all")
    interface Path extends Uri {
        /**
         * 功能集分页列表 URL{@value}
         */
        String PAGE = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/resourcesets";
    }
}
