package com.xforceplus.api.tenant.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ServicePackageModel.Request.Query;
import com.xforceplus.domain.resource.ServicePackageDto;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 服务包相关接口 (global)
 *
 * @author geewit
 */
public interface ServicePackageApi {
    @ResponseBody
    @RequestMapping(name = "服务包分页列表", value = Path.PAGE, method = RequestMethod.GET)
    <T extends ServicePackageDto> ResponseEntity<Page<T>> page(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                               @SpringQueryMap Query query,
                                                               Pageable pageable);

    @SuppressWarnings("all")
    interface Path extends Uri {
        String PAGE = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/packages";
    }

}
