package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.api.model.UserModel.Request.*;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 租户的用户接口 (tenant)
 *
 * @author geewit
 */
public interface UserApi {
    @ResponseBody
    @RequestMapping(name = "用户列表", value = Path.PAGE, method = RequestMethod.GET)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> page(@PathVariable("tenantKey") String tenantKey,
                                                                                                                            @SpringQueryMap Query query,
                                                                                                                            Pageable pageable);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> page(long tenantId,
                                                                                                                                    Query query,
                                                                                                                                    Pageable pageable) {
        query.setByTenantCode(false);
        return this.page(String.valueOf(tenantId), query, pageable);
    }


    @ResponseBody
    @RequestMapping(name = "用户列表", value = Path.LIST, method = RequestMethod.GET)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<List<U>> list(@PathVariable("tenantKey") String tenantKey,
                                                                                                                            @SpringQueryMap Query query,
                                                                                                                            Sort sort);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<List<U>> list(long tenantId,
                                                                                                                                    Query query,
                                                                                                                                    Sort sort) {
        query.setByTenantCode(false);
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name = "新增用户", value = Path.CREATE, method = RequestMethod.POST)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(@PathVariable("tenantKey") String tenantKey,
                                                                                                                        @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                                                                        @RequestBody @Valid Create model);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(long tenantId,
                                                                                                                                Create model) {
        return this.create(String.valueOf(tenantId), false, model);
    }

    @ResponseBody
    @RequestMapping(name = "新增人员信息", value = Path.SIMPLE_CREATE, method = RequestMethod.POST)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(@PathVariable("tenantKey") String tenantKey,
                                                                                                                              @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                                                                              @RequestBody @Valid SimpleCreate model);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(long tenantId,
                                                                                                                                      SimpleCreate model) {
        return this.simpleCreate(String.valueOf(tenantId), false, model);
    }

    @ResponseBody
    @RequestMapping(name = "批量导入用户", value = Path.BATCH_IMPORT, method = RequestMethod.POST)
    ResponseEntity<Boolean> batchImport(@PathVariable("tenantKey") String tenantKey,
                                        @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                        @RequestBody @Valid BatchImport batchImport);


    default ResponseEntity<Boolean> batchImport(long tenantId,
                                                BatchImport batchImport) {
        return this.batchImport(String.valueOf(tenantId), false, batchImport);
    }

    @ResponseBody
    @RequestMapping(name = "批量往组织导入用户", value = Path.BATCH_IMPORT_INTO_ORG, method = RequestMethod.POST)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Response.BatchCreateResult<U, O, R, A>> batchImportIntoOrg(@PathVariable("tenantKey") String tenantKey,
                                                                                                                                                                       @PathVariable("orgKey") String orgKey,
                                                                                                                                                                       @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                                                                                                                       @RequestParam(value = "byOrgCode", required = false) Boolean byOrgCode,
                                                                                                                                                                       @RequestBody @Valid List<@Valid Create> models);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Response.BatchCreateResult<U, O, R, A>> batchImportIntoOrg(long tenantId,
                                                                                                                                                                               long orgId,
                                                                                                                                                                               List<Create> models) {
        return this.batchImportIntoOrg(String.valueOf(tenantId), String.valueOf(orgId), false, false, models);
    }

    @ResponseBody
    @RequestMapping(name = "更新用户", value = Path.UPDATE, method = RequestMethod.PUT)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(@PathVariable("tenantKey") String tenantKey,
                                                                                                                        @PathVariable("userKey") String userKey,
                                                                                                                        @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                                                                        @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
                                                                                                                        @RequestBody Update model);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(long tenantId,
                                                                                                                                long userId,
                                                                                                                                Update model) {
        return this.update(String.valueOf(tenantId), String.valueOf(userId), false, false, model);
    }

    @ResponseBody
    @RequestMapping(name = "更新用户", value = Path.SIMPLE_UPDATE, method = RequestMethod.PUT)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(@PathVariable("tenantKey") String tenantKey,
                                                                                                                              @PathVariable("userKey") String userKey,
                                                                                                                              @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                                                                              @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
                                                                                                                              @RequestBody SimpleUpdate model);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(long tenantId,
                                                                                                                                      long userId,
                                                                                                                                      SimpleUpdate model) {
        return this.simpleUpdate(String.valueOf(tenantId), String.valueOf(userId), false, false, model);
    }

    @ResponseBody
    @RequestMapping(name = "获取用户信息", value = Path.INFO, method = RequestMethod.GET)
    <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> info(@PathVariable("tenantKey") String tenantKey,
                                                                                                                      @PathVariable("userKey") String userKey,
                                                                                                                      @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                                                                      @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
                                                                                                                      @RequestParam(value = "loginId", required = false) String loginId,
                                                                                                                      @RequestParam(value = "modules", required = false) String modules,
                                                                                                                      @RequestParam(value = "extraInfo", required = false, defaultValue = "0") int extraInfoDimension);

    default <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> info(long tenantId,
                                                                                                                              long userId,
                                                                                                                              String loginId,
                                                                                                                              String modules,
                                                                                                                              int extraInfoDimension) {
        return this.info(String.valueOf(tenantId), String.valueOf(userId), false, false, loginId, modules, extraInfoDimension);
    }

    @Deprecated
    @ResponseBody
    @RequestMapping(name = "删除用户", value = Path.DELETE, method = RequestMethod.DELETE)
    ResponseEntity<String> delete(@PathVariable("tenantKey") String tenantKey,
                                  @PathVariable("userKey") String userKey,
                                  @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                  @RequestParam(value = "byUserCode", required = false) Boolean byUserCode);

    default ResponseEntity<String> delete(long tenantId,
                                          long userId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(userId), false, false);
    }

    @ResponseBody
    @RequestMapping(name = "用户绑定角色列表", value = Path.USER_BIND_ROLES, method = RequestMethod.POST)
    ResponseEntity<String> bindRoles(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
            @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
            @RequestBody BindRoles bindRoles);

    default ResponseEntity<String> bindRoles(
            long tenantId,
            long userId,
            BindRoles bindRoles) {
        return this.bindRoles(String.valueOf(tenantId), String.valueOf(userId), false, false, bindRoles);
    }

    @ResponseBody
    @RequestMapping(name = "用户新增绑定税控设备", value = Path.USER_BIND_EQUIPMENTS, method = RequestMethod.POST)
    ResponseEntity<String> bindPrintingEquipment(@PathVariable("tenantKey") Long tenantKey,
                                                 @PathVariable("userKey") Long userKey,
                                                 @RequestBody List<String> equipmentList);

    @ResponseBody
    @RequestMapping(name = "用户解绑税控设备", value = Path.USER_UNBIND_EQUIPMENTS, method = RequestMethod.POST)
    ResponseEntity<String> unbindPrintingEquipment(@PathVariable("tenantKey") Long tenantKey,
                                                   @PathVariable("userKey") Long userId,
                                                   @RequestBody List<String> equipmentList);

    @ResponseBody
    @RequestMapping(name = "用户新增绑定税控终端", value = Path.USER_BIND_TERMINALS, method = RequestMethod.POST)
    ResponseEntity<String> bindTicketTerminal(@PathVariable("tenantKey") Long tenantId,
                                              @PathVariable("userKey") Long userId, @RequestBody List<String> terminalList);

    @ResponseBody
    @RequestMapping(name = "用户解绑税控终端", value = Path.USER_UNBIND_TERMINALS, method = RequestMethod.POST)
    ResponseEntity<String> unbindTicketTerminal(@PathVariable("tenantKey") Long tenantId,
                                                @PathVariable("userKey") Long userId, @RequestBody List<String> terminalList);


    @ResponseBody
    @RequestMapping(name = "用户反绑定角色列表", value = Path.USER_UNBIND_ROLES, method = RequestMethod.POST)
    ResponseEntity<String> unbindRoles(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
            @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
            @RequestBody UnbindRoles unbindRoles);

    default ResponseEntity<String> unbindRoles(
            long tenantId,
            long userId,
            UnbindRoles unbindRoles) {
        return this.unbindRoles(String.valueOf(tenantId), String.valueOf(userId), false, false, unbindRoles);
    }

    @ResponseBody
    @RequestMapping(name = "用户绑定组织列表", value = Path.USER_BIND_ORGS, method = RequestMethod.POST)
    ResponseEntity<String> bindOrgs(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
            @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
            @RequestBody BindOrgs bindOrgs);

    default ResponseEntity<String> bindOrgs(
            long tenantId,
            long userId,
            BindOrgs bindOrgs) {
        return this.bindOrgs(String.valueOf(tenantId), String.valueOf(userId), false, false, bindOrgs);
    }

    @ResponseBody
    @RequestMapping(name = "用户反绑定组织列表", value = Path.USER_UNBIND_ORGS, method = RequestMethod.POST)
    ResponseEntity<String> unbindOrgs(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
            @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
            @RequestBody UnbindOrgs unbindOrgs);

    default ResponseEntity<String> unbindOrgs(
            long tenantId,
            long userId,
            UnbindOrgs unbindOrgs) {
        return this.unbindOrgs(String.valueOf(tenantId), String.valueOf(userId), false, false, unbindOrgs);
    }

    @ResponseBody
    @RequestMapping(name = "更新用户状态", value = Path.UPDATE_STATUS, method = RequestMethod.PATCH)
    ResponseEntity<String> updateStatus(@PathVariable("tenantKey") String tenantKey,
                                        @PathVariable("userKey") String userKey,
                                        @PathVariable("status") @Valid @Range(max = 1L) int status,
                                        @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                        @RequestParam(value = "byUserCode", required = false) Boolean byUserCode);

    default ResponseEntity<String> updateStatus(long tenantId,
                                                long userId,
                                                int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(userId), status, false, false);
    }

    @ResponseBody
    @RequestMapping(name = "租户下用户的资源码集合", value = Path.RESOURCES, method = RequestMethod.GET)
    ResponseEntity<Set<String>> userResources(@PathVariable("tenantKey") String tenantKey,
                                              @PathVariable("userKey") String userKey,
                                              @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                              @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
                                              @RequestParam(value = "loginId", required = false) String loginId,
                                              @RequestParam(value = "modules", required = false) String modules);


    default ResponseEntity<Set<String>> userResources(long tenantId, long userId, String loginId, String modules) {
        return this.userResources(String.valueOf(tenantId), String.valueOf(userId), false, false, loginId, modules);
    }


    @ResponseBody
    @RequestMapping(name = "用户的多个应用资源码集合", value = Path.APPS_RESOURCES, method = RequestMethod.GET)
    ResponseEntity<Map<Long, Set<String>>> appsResources(@PathVariable("tenantKey") String tenantKey,
                                                         @PathVariable("userKey") String userKey,
                                                         @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                         @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
                                                         @RequestParam("appIds") String appIds,
                                                         @RequestParam(value = "loginId", required = false) String loginId,
                                                         @RequestParam(value = "modules", required = false) String modules);

    default ResponseEntity<Map<Long, Set<String>>> appsResources(long tenantId, long userId, String appIds, String loginId, String modules) {
        return this.appsResources(String.valueOf(tenantId), String.valueOf(userId), false, false, appIds, loginId, modules);
    }


    @ResponseBody
    @RequestMapping(name = "批量导入用户", value = Path.BATCH_IMPORT_2, method = RequestMethod.POST)
    ResponseEntity<Boolean> batchImportFromExcel(@PathVariable("tenantKey") String tenantKey,
                                                 @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                 @RequestParam("file") MultipartFile file);

    @ResponseBody
    @RequestMapping(name = "当前租户下禁用指定用户", value = Path.DISABLE, method = RequestMethod.PATCH)
    ResponseEntity<String> tenantDisable(@PathVariable("tenantKey") String tenantKey,
                                         @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                         @PathVariable("userId") long userId);


    @ResponseBody
    @RequestMapping(name = "获取指定的usertag信息", value = Path.USER_TAG, method = RequestMethod.GET)
    ResponseEntity<String> userTag(@PathVariable(value="tenantKey") String tenantKey,
        @PathVariable(value="userKey") String userKey,
        @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
        @RequestParam(value = "byUserCode", required = false) Boolean byUserCode,
        @RequestParam(value="tagName") String tagName);

    @SuppressWarnings("all")
    interface Path extends Uri {
        String API_PREFIX = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users";
        String PAGE = API_PREFIX;
        String LIST = API_PREFIX + "/list";
        String CREATE = API_PREFIX;
        String SIMPLE_CREATE = API_PREFIX + "/simple";
        String BATCH_IMPORT = API_PREFIX + "/batch";
        String BATCH_IMPORT_2 = API_PREFIX + "/batch/import";
        String BATCH_IMPORT_INTO_ORG = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}/users/batch";
        String UPDATE = API_PREFIX + "/{userKey}";
        String SIMPLE_UPDATE = API_PREFIX + "/{userKey}/simple";
        String INFO = API_PREFIX + "/{userKey}";
        String DELETE = API_PREFIX + "/{userKey}";
        String RESOURCES = API_PREFIX + "/{userKey}/resources";
        String APPS_RESOURCES = API_PREFIX + "/{userKey}/apps-resources";
        String USER_BIND_ROLES = API_PREFIX + "/{userKey}/roles";
        String USER_UNBIND_ROLES = API_PREFIX + "/{userKey}/roles/unbind";
        String USER_BIND_ORGS = API_PREFIX + "/{userKey}/orgs";
        String USER_UNBIND_ORGS = API_PREFIX + "/{userKey}/orgs/unbind";
        String UPDATE_STATUS = API_PREFIX + "/{userKey}/status/{status}";
        String USER_BIND_EQUIPMENTS = API_PREFIX + "/{userKey}/equipment/bind";
        String USER_UNBIND_EQUIPMENTS = API_PREFIX + "/{userKey}/equipment/unbind";
        String USER_BIND_TERMINALS = API_PREFIX + "/{userKey}/terminal/bind";
        String USER_UNBIND_TERMINALS = API_PREFIX + "/{userKey}/terminal/unbind";
        String DISABLE = API_PREFIX + "/{userId}/disable";
        String USER_TAG = API_PREFIX + "/{userKey}/tag";

    }

}
