/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.company;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.validation.ValidationGroup;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import java.util.Date;
import java.util.Map;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface CompanyApi {
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<C>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap CompanyModel.Request.Query var2, Pageable var3);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<C>> page(long tenantId, CompanyModel.Request.Query query, Pageable pageable) {
        query.setByTenantCode(Boolean.valueOf(false));
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u516c\u53f8\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var4, @RequestParam(value="revisionDate", required=false) Date var5, @RequestParam(value="withExtendParams", required=false) String var6);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> info(long tenantId, long companyId, Date revisionDate, String withExtendParams) {
        return this.info(String.valueOf(tenantId), String.valueOf(companyId), false, false, revisionDate, withExtendParams);
    }

    @ResponseBody
    @RequestMapping(name="\u67e5\u6307\u5b9a\u516c\u53f8\u53d8\u66f4\u5386\u53f2\u5206\u9875\u8bb0\u5f55", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}/histories"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<ComparedRevision<C, String>>> histories(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var4, Pageable var5);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<ComparedRevision<C, String>>> histories(long tenantId, long companyId, Pageable pageable) {
        return this.histories(String.valueOf(tenantId), String.valueOf(companyId), false, false, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies"}, method={RequestMethod.POST})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> create(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) CompanyModel.Request.Save var3);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> create(long tenantId, @RequestBody CompanyModel.Request.Save company) {
        return this.create(String.valueOf(tenantId), false, company);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}"}, method={RequestMethod.PUT})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var4, @RequestBody CompanyModel.Request.Save var5);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> update(long tenantId, long companyId, CompanyModel.Request.Save company) {
        return this.update(String.valueOf(tenantId), String.valueOf(companyId), false, false, company);
    }

    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u7ed1\u5b9a\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}/packages"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindPackages(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var4, @RequestBody CompanyModel.Request.BindPackages var5);

    default public ResponseEntity<String> bindPackages(long tenantId, long companyId, CompanyModel.Request.BindPackages bindPackage) {
        return this.bindPackages(String.valueOf(tenantId), String.valueOf(companyId), false, false, bindPackage);
    }

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u516c\u53f8\u540d\u79f0", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/companyname"}, method={RequestMethod.POST})
    public ResponseEntity<String> updateCompanyName(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", defaultValue="false") Boolean var2, @RequestBody @Valid CompanyModel.Request.CompanyName var3);

    default public ResponseEntity<String> updateCompanyName(long tenantId, CompanyModel.Request.CompanyName companyName) {
        return this.updateCompanyName(String.valueOf(tenantId), false, companyName);
    }

    @ResponseBody
    @RequestMapping(name="\u8bbe\u7f6e\u516c\u53f8\u7ec8\u7aef\u9274\u6743", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/terminal/{companyKey}"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> setCompanyTerminalAuthSwitch(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", defaultValue="false") Boolean var3, @RequestParam(value="byTaxNum", defaultValue="false") Boolean var4, @RequestParam(value="terminalSwitch") @Valid @Range(min=0L, max=1L) @Valid @Range(min=0L, max=1L) int var5);

    default public ResponseEntity<Boolean> setCompanyTerminalAuthSwitch(long tenantId, long companyId, int terminalSwitch) {
        return this.setCompanyTerminalAuthSwitch(String.valueOf(tenantId), String.valueOf(companyId), false, false, terminalSwitch);
    }

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u516c\u53f8\u7ec8\u7aef\u9274\u6743", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/terminal/{companyKey}"}, method={RequestMethod.GET})
    public ResponseEntity<Integer> getCompanyTerminalAuthSwitch(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", defaultValue="false") Boolean var3, @RequestParam(value="byTaxNum", defaultValue="false") Boolean var4);

    default public ResponseEntity<Integer> getCompanyTerminalAuthSwitch(long tenantId, long companyId) {
        return this.getCompanyTerminalAuthSwitch(String.valueOf(tenantId), String.valueOf(companyId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u9a8c\u8bc1\u79df\u6237\u4e0b\u516c\u6307\u5b9a\u516c\u53f8\u7684\u591a\u4e2a\u670d\u52a1\u5305\u662f\u5426\u88ab\u89d2\u8272\u7ed1\u5b9a", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}/packages/validation"}, method={RequestMethod.GET})
    public ResponseEntity<Map<Long, Boolean>> validCompaniesPackagesBound(@PathVariable(value="tenantKey") String var1, @PathVariable(value="companyKey") String var2, @RequestParam(value="byTenantCode", defaultValue="false") Boolean var3, @RequestParam(value="byTaxNum", defaultValue="false") Boolean var4, @RequestParam(value="packageIds") String var5);

    default public ResponseEntity<Map<Long, Boolean>> validCompaniesPackagesBound(long tenantId, long companyId, String packageIds) {
        return this.validCompaniesPackagesBound(String.valueOf(tenantId), String.valueOf(companyId), false, false, packageIds);
    }

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/list";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}";
        public static final String HISTORIES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}/histories";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}";
        public static final String BIND_PACKAGES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}/packages";
        public static final String UPDATE_COMPANY_NAME = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/companyname";
        public static final String AUTH_SWITCH = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/terminal/{companyKey}";
        public static final String VALID_PACKAGES_WERE_BOUND = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/{companyKey}/packages/validation";
    }
}

