/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.org;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface OrgApi {
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<Page<O>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap OrgModel.Request.Query var2, Pageable var3);

    default public <O extends OrgDto<O>> ResponseEntity<Page<O>> page(long tenantId, OrgModel.Request.Query query, Pageable pageable) {
        query.setByTenantCode(Boolean.valueOf(false));
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/list"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> list(@PathVariable(value="tenantKey") String var1, @SpringQueryMap OrgModel.Request.Query var2, Sort var3);

    default public <O extends OrgDto<O>> ResponseEntity<List<O>> list(long tenantId, OrgModel.Request.Query query, Sort sort) {
        query.setByTenantCode(Boolean.valueOf(false));
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u65b0\u589e\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.POST})
    public <O extends OrgDto<O>> ResponseEntity<O> create(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) OrgModel.Request.Save var3);

    default public <O extends OrgDto<O>> ResponseEntity<O> create(long tenantId, OrgModel.Request.Save model) {
        return this.create(String.valueOf(tenantId), false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u5411\u6307\u5b9a\u7236\u7ec4\u7ec7\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{parentKey}/batch"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImportChildrenIntoParent(@PathVariable(value="tenantKey") String var1, @PathVariable(value="parentKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgModel.Request.Save> var5);

    default public ResponseEntity<Boolean> batchImportChildrenIntoParent(long tenantId, long parentId, List<OrgModel.Request.Save> models) {
        return this.batchImportChildrenIntoParent(String.valueOf(tenantId), String.valueOf(parentId), false, false, models);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImport(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgModel.Request.Save> var3);

    default public ResponseEntity<Boolean> batchImport(long tenantId, List<OrgModel.Request.Save> models) {
        return this.batchImport(String.valueOf(tenantId), false, models);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u66f4\u65b0\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}"}, method={RequestMethod.PUT})
    public <O extends OrgDto<O>> ResponseEntity<O> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4, @RequestBody @Validated(value={ValidationGroup.OnUpdate.class}) OrgModel.Request.Save var5);

    default public <O extends OrgDto<O>> ResponseEntity<O> update(long tenantId, long orgId, OrgModel.Request.Save org) {
        return this.update(String.valueOf(tenantId), String.valueOf(orgId), false, false, org);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u66f4\u65b0\u7ec4\u7ec7\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3, @RequestParam(value="byTenantCode", required=false) Boolean var4, @RequestParam(value="byOrgCode", required=false) Boolean var5);

    default public ResponseEntity<String> updateStatus(long tenantId, long orgId, int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(orgId), status, false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<O> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4);

    default public <O extends OrgDto<O>> ResponseEntity<O> info(long tenantId, long orgId) {
        return this.info(String.valueOf(tenantId), String.valueOf(orgId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u79df\u6237\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4);

    default public ResponseEntity<String> delete(long tenantId, long orgId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(orgId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/tree"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<O> tree(@PathVariable(value="tenantKey") String var1, @SpringQueryMap OrgModel.Request.TreeQuery var2);

    default public <O extends OrgDto<O>> ResponseEntity<O> tree(long tenantId, OrgModel.Request.TreeQuery treeQuery) {
        return this.tree(String.valueOf(tenantId), treeQuery);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u6839\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/roots"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> roots(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestParam(value="userId", required=false) Long var3, @RequestParam(value="withUserBoundFlag", required=false) Boolean var4);

    default public <O extends OrgDto<O>> ResponseEntity<List<O>> roots(long tenantId, Long userId, Boolean withUserBoundFlag) {
        return this.roots(String.valueOf(tenantId), false, userId, withUserBoundFlag);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5b50\u8282\u70b9", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/children"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> children(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4, @RequestParam(value="userId", required=false) Long var5, @RequestParam(value="withUserBoundFlag", required=false) Boolean var6);

    default public <O extends OrgDto<O>> ResponseEntity<List<O>> children(long tenantId, long orgId, Long userId, Boolean withUserBoundFlag) {
        return this.children(String.valueOf(tenantId), String.valueOf(orgId), false, false, userId, withUserBoundFlag);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5b50\u5b59", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/descendants"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> descendants(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4);

    default public <O extends OrgDto<O>> ResponseEntity<List<O>> descendants(long tenantId, long orgId) {
        return this.descendants(String.valueOf(tenantId), String.valueOf(orgId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/users"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> users(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @SpringQueryMap UserModel.Request.Query var3, Pageable var4);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> users(long tenantId, long orgId, UserModel.Request.Query query, Pageable pageable) {
        query.setByTenantCode(Boolean.valueOf(false));
        query.setByOrgCode(Boolean.valueOf(false));
        return this.users(String.valueOf(tenantId), String.valueOf(orgId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u8282\u70b9ids\u67e5\u8be2\u7ec4\u7ec7\uff08\u8fd4\u56deids\u5bf9\u5e94\u5206\u7ec4\uff09", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/list/orgKeys"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> listByOrgKeys(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestParam(value="scope") TreeModel.OrgScope var3, @RequestParam(value="byId", required=false, defaultValue="true") boolean var4, @RequestParam(value="orgKeys") String var5);

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs";
        public static final String POST_PAGE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/orgs/postquery";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs";
        public static final String BATCH_IMPORT_CHILDREN_INTO_PARENT = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{parentKey}/batch";
        public static final String BATCH_IMPORT_WITH_RESULT = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch-with-result";
        public static final String BATCH_IMPORT = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/status/{status}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}";
        public static final String TREE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/tree";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}";
        public static final String ROOTS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/roots";
        public static final String CHILDREN = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/children";
        public static final String DESCENDANTS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/descendants";
        public static final String USERS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/users";
        public static final String BATCH_IMPORT_2 = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/excel";
        public static final String BATCH_EXPORT_EXCEL = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/export";
        public static final String DOWNLOAD_EXCEL = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/download/{fileId}";
        public static final String LIST_BY_ORGKEYS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/list/orgKeys";
    }
}

