/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public interface RoleApi {
    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<Page<T>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap RoleModel.Request.Query var2, Pageable var3);

    default public <T extends RoleDto> ResponseEntity<Page<T>> page(long tenantId, RoleModel.Request.Query query, Pageable pageable) {
        query.setByTenantCode(Boolean.valueOf(false));
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles"}, method={RequestMethod.POST})
    public <T extends RoleDto> ResponseEntity<T> create(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) @Validated(value={ValidationGroup.OnCurrentTenantCreate.class}) Boolean var2, @RequestBody RoleModel.Request.Save var3);

    default public <T extends RoleDto> ResponseEntity<T> create(long tenantId, RoleModel.Request.Save model) {
        return this.create(String.valueOf(tenantId), false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/batch"}, method={RequestMethod.POST})
    public <R extends RoleDto> ResponseEntity<List<R>> batchCreate(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody List<RoleModel.Request.Save> var3);

    default public <R extends RoleDto> ResponseEntity<List<R>> batchCreate(long tenantId, List<RoleModel.Request.Save> models) {
        return this.batchCreate(String.valueOf(tenantId), false, models);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}"}, method={RequestMethod.PUT})
    public <T extends RoleDto> ResponseEntity<T> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4, @RequestBody @Valid RoleModel.Request.Save var5);

    default public <T extends RoleDto> ResponseEntity<T> update(long tenantId, long roleId, RoleModel.Request.Save model) {
        return this.update(String.valueOf(tenantId), String.valueOf(roleId), false, false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var5);

    default public ResponseEntity<String> updateStatus(long tenantId, long roleId, int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(roleId), false, false, status);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<T> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4);

    default public <T extends RoleDto> ResponseEntity<T> info(long tenantId, long roleId) {
        return this.info(String.valueOf(tenantId), String.valueOf(roleId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4);

    default public ResponseEntity<String> delete(long tenantId, long roleId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(roleId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> users(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @SpringQueryMap UserModel.Request.Query var3, Pageable var4);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> users(long tenantId, long roleId, UserModel.Request.Query query, Pageable pageable) {
        query.setByTenantCode(Boolean.valueOf(false));
        query.setByRoleCode(Boolean.valueOf(false));
        return this.users(String.valueOf(tenantId), String.valueOf(roleId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/resources"}, method={RequestMethod.GET})
    public <T extends ResourceDto> ResponseEntity<Page<T>> resources(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4, Pageable var5);

    default public <T extends ResourceDto> ResponseEntity<Page<T>> resources(long tenantId, long roleId, Pageable pageable) {
        return this.resources(String.valueOf(tenantId), String.valueOf(roleId), false, false, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindUsers(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4, @RequestBody RoleModel.Request.BindUsers var5);

    default public ResponseEntity<String> bindUsers(long tenantId, long roleId, RoleModel.Request.BindUsers bindUsers) {
        return this.bindUsers(String.valueOf(tenantId), String.valueOf(roleId), false, false, bindUsers);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u6279\u91cf\u53cd\u7ed1\u5b9a\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindUsers(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byRoleCode", required=false) Boolean var4, @RequestBody RoleModel.Request.UnbindUsers var5);

    default public ResponseEntity<String> unbindUsers(long tenantId, long roleId, RoleModel.Request.UnbindUsers unbindUsers) {
        return this.unbindUsers(String.valueOf(tenantId), String.valueOf(roleId), false, false, unbindUsers);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u5173\u8054\u8d26\u53f7\u548c\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/bind/users"}, method={RequestMethod.POST})
    public ResponseEntity<Long> batchImportBind(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestParam(value="file") MultipartFile var3);

    public static interface Path
    extends Uri {
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles";
        public static final String BATCH_CREATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/batch";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/status/{status}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}";
        public static final String USERS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users";
        public static final String RESOURCES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/resources";
        public static final String BIND_RESOURCE_SET = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/resource-sets";
        public static final String BIND_USERS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users";
        public static final String UNBIND_USERS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users/unbind";
        public static final String BATCH_IMPORT = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/bind/users";
    }
}

