/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public interface UserApi {
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap UserModel.Request.Query var2, Pageable var3);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> page(long tenantId, UserModel.Request.Query query, Pageable pageable) {
        query.setByTenantCode(Boolean.valueOf(false));
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/list"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<List<U>> list(@PathVariable(value="tenantKey") String var1, @SpringQueryMap UserModel.Request.Query var2, Sort var3);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<List<U>> list(long tenantId, UserModel.Request.Query query, Sort sort) {
        query.setByTenantCode(Boolean.valueOf(false));
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Valid UserModel.Request.Save var3);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(long tenantId, UserModel.Request.Save model) {
        return this.create(String.valueOf(tenantId), false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u5458\u5de5\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/simple"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Valid UserModel.Request.SimpleSave var3);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(long tenantId, UserModel.Request.SimpleSave model) {
        return this.simpleCreate(String.valueOf(tenantId), false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/batch"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImport(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Valid UserModel.Request.BatchImport var3);

    default public ResponseEntity<Boolean> batchImport(long tenantId, UserModel.Request.BatchImport batchImport) {
        return this.batchImport(String.valueOf(tenantId), false, batchImport);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5f80\u7ec4\u7ec7\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/users/batch"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Response.BatchCreateResult<U, O, R, A>> batchImportIntoOrg(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byOrgCode", required=false) Boolean var4, @RequestBody @Valid @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid UserModel.Request.Save> var5);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Response.BatchCreateResult<U, O, R, A>> batchImportIntoOrg(long tenantId, long orgId, List<UserModel.Request.Save> models) {
        return this.batchImportIntoOrg(String.valueOf(tenantId), String.valueOf(orgId), false, false, models);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}"}, method={RequestMethod.PUT})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestBody UserModel.Request.Save var5);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(long tenantId, long userId, UserModel.Request.Save model) {
        return this.update(String.valueOf(tenantId), String.valueOf(userId), false, false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/simple"}, method={RequestMethod.PUT})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestBody UserModel.Request.SimpleSave var5);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(long tenantId, long userId, UserModel.Request.SimpleSave model) {
        return this.simpleUpdate(String.valueOf(tenantId), String.valueOf(userId), false, false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestParam(value="loginId", required=false) String var5, @RequestParam(value="modules", required=false) String var6, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var7);

    default public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> info(long tenantId, long userId, String loginId, String modules, int extraInfoDimension) {
        return this.info(String.valueOf(tenantId), String.valueOf(userId), false, false, loginId, modules, extraInfoDimension);
    }

    @Deprecated
    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4);

    default public ResponseEntity<String> delete(long tenantId, long userId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(userId), false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindRoles(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestBody UserModel.Request.BindRoles var5);

    default public ResponseEntity<String> bindRoles(long tenantId, long userId, UserModel.Request.BindRoles bindRoles) {
        return this.bindRoles(String.valueOf(tenantId), String.valueOf(userId), false, false, bindRoles);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u65b0\u589e\u7ed1\u5b9a\u7a0e\u63a7\u8bbe\u5907", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/equipment/bind"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindPrintingEquipment(@PathVariable(value="tenantKey") Long var1, @PathVariable(value="userKey") Long var2, @RequestBody List<String> var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u89e3\u7ed1\u7a0e\u63a7\u8bbe\u5907", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/equipment/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindPrintingEquipment(@PathVariable(value="tenantKey") Long var1, @PathVariable(value="userKey") Long var2, @RequestBody List<String> var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u65b0\u589e\u7ed1\u5b9a\u7a0e\u63a7\u7ec8\u7aef", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/terminal/bind"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindTicketTerminal(@PathVariable(value="tenantKey") Long var1, @PathVariable(value="userKey") Long var2, @RequestBody List<String> var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u89e3\u7ed1\u7a0e\u63a7\u7ec8\u7aef", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/terminal/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindTicketTerminal(@PathVariable(value="tenantKey") Long var1, @PathVariable(value="userKey") Long var2, @RequestBody List<String> var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u53cd\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindRoles(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestBody UserModel.Request.UnbindRoles var5);

    default public ResponseEntity<String> unbindRoles(long tenantId, long userId, UserModel.Request.UnbindRoles unbindRoles) {
        return this.unbindRoles(String.valueOf(tenantId), String.valueOf(userId), false, false, unbindRoles);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindOrgs(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestBody UserModel.Request.BindOrgs var5);

    default public ResponseEntity<String> bindOrgs(long tenantId, long userId, UserModel.Request.BindOrgs bindOrgs) {
        return this.bindOrgs(String.valueOf(tenantId), String.valueOf(userId), false, false, bindOrgs);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u53cd\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindOrgs(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestBody UserModel.Request.UnbindOrgs var5);

    default public ResponseEntity<String> unbindOrgs(long tenantId, long userId, UserModel.Request.UnbindOrgs unbindOrgs) {
        return this.unbindOrgs(String.valueOf(tenantId), String.valueOf(userId), false, false, unbindOrgs);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3, @RequestParam(value="byTenantCode", required=false) Boolean var4, @RequestParam(value="byUserCode", required=false) Boolean var5);

    default public ResponseEntity<String> updateStatus(long tenantId, long userId, int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(userId), status, false, false);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u4e0b\u7528\u6237\u7684\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> userResources(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestParam(value="loginId", required=false) String var5, @RequestParam(value="modules", required=false) String var6);

    default public ResponseEntity<Set<String>> userResources(long tenantId, long userId, String loginId, String modules) {
        return this.userResources(String.valueOf(tenantId), String.valueOf(userId), false, false, loginId, modules);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u591a\u4e2a\u5e94\u7528\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/apps-resources"}, method={RequestMethod.GET})
    public ResponseEntity<Map<Long, Set<String>>> appsResources(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestParam(value="appIds") String var5, @RequestParam(value="loginId", required=false) String var6, @RequestParam(value="modules", required=false) String var7);

    default public ResponseEntity<Map<Long, Set<String>>> appsResources(long tenantId, long userId, String appIds, String loginId, String modules) {
        return this.appsResources(String.valueOf(tenantId), String.valueOf(userId), false, false, appIds, loginId, modules);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/batch/import"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImportFromExcel(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestParam(value="file") MultipartFile var3);

    @ResponseBody
    @RequestMapping(name="\u5f53\u524d\u79df\u6237\u4e0b\u7981\u7528\u6307\u5b9a\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userId}/disable"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> tenantDisable(@PathVariable(value="tenantKey") String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @PathVariable(value="userId") long var3);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u6307\u5b9a\u7684usertag\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/tag"}, method={RequestMethod.GET})
    public ResponseEntity<String> userTag(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="byTenantCode", required=false) Boolean var3, @RequestParam(value="byUserCode", required=false) Boolean var4, @RequestParam(value="tagName") String var5);

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users";
        public static final String SIMPLE_CREATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/simple";
        public static final String BATCH_IMPORT = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/batch";
        public static final String BATCH_IMPORT_2 = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/batch/import";
        public static final String BATCH_IMPORT_INTO_ORG = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/users/batch";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}";
        public static final String SIMPLE_UPDATE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/simple";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}";
        public static final String RESOURCES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/resources";
        public static final String APPS_RESOURCES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/apps-resources";
        public static final String USER_BIND_ROLES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles";
        public static final String USER_UNBIND_ROLES = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles/unbind";
        public static final String USER_BIND_ORGS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs";
        public static final String USER_UNBIND_ORGS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs/unbind";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/status/{status}";
        public static final String USER_BIND_EQUIPMENTS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/equipment/bind";
        public static final String USER_UNBIND_EQUIPMENTS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/equipment/unbind";
        public static final String USER_BIND_TERMINALS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/terminal/bind";
        public static final String USER_UNBIND_TERMINALS = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/terminal/unbind";
        public static final String DISABLE = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userId}/disable";
        public static final String USER_TAG = "${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/tag";
    }
}

