/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.org;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface OrgApi {
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<Page<T>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap OrgModel.Request.Query var2, Pageable var3);

    default public <T extends OrgDto<T>> ResponseEntity<Page<T>> page(long tenantId, OrgModel.Request.Query query, Pageable pageable) {
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/list"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<List<T>> list(@PathVariable(value="tenantKey") String var1, @SpringQueryMap OrgModel.Request.Query var2, Sort var3);

    default public <T extends OrgDto<T>> ResponseEntity<List<T>> list(long tenantId, OrgModel.Request.Query query, Sort sort) {
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u65b0\u589e\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.POST})
    public <T extends OrgDto<T>> ResponseEntity<T> create(@PathVariable(value="tenantKey") String var1, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) OrgModel.Request.Save var2);

    default public <T extends OrgDto<T>> ResponseEntity<T> create(long tenantId, OrgModel.Request.Save model) {
        return this.create(String.valueOf(tenantId), model);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u5411\u6307\u5b9a\u7236\u7ec4\u7ec7\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{parentKey}/batch"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImportChildrenIntoParent(@PathVariable(value="tenantKey") String var1, @PathVariable(value="parentKey") String var2, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgModel.Request.Save> var3);

    default public ResponseEntity<Boolean> batchImportChildrenIntoParent(long tenantId, long parentId, List<OrgModel.Request.Save> models) {
        return this.batchImportChildrenIntoParent(String.valueOf(tenantId), String.valueOf(parentId), models);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImport(@PathVariable(value="tenantKey") String var1, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgModel.Request.Save> var2);

    default public ResponseEntity<Boolean> batchImport(long tenantId, List<OrgModel.Request.Save> models) {
        return this.batchImport(String.valueOf(tenantId), models);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u6279\u91cf\u5bfc\u5165\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch-with-result"}, method={RequestMethod.POST})
    public <T extends OrgDto<T>> ResponseBoolenEntity<Boolean, T> batchImportWithResult(@PathVariable(value="tenantKey") String var1, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgModel.Request.Save> var2);

    default public <T extends OrgDto<T>> ResponseBoolenEntity<Boolean, T> batchImportWithResult(long tenantId, List<OrgModel.Request.Save> models) {
        return this.batchImportWithResult(String.valueOf(tenantId), models);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u66f4\u65b0\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}"}, method={RequestMethod.PUT})
    public <T extends OrgDto<T>> ResponseEntity<T> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestBody OrgModel.Request.Save var3);

    default public <T extends OrgDto<T>> ResponseEntity<T> update(long tenantId, long orgId, OrgModel.Request.Save org) {
        return this.update(String.valueOf(tenantId), String.valueOf(orgId), org);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u66f4\u65b0\u7ec4\u7ec7\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    default public ResponseEntity<String> updateStatus(long tenantId, long orgId, int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(orgId), status);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2);

    default public <T extends OrgDto<T>> ResponseEntity<T> info(long tenantId, long orgId) {
        return this.info(String.valueOf(tenantId), String.valueOf(orgId));
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/tree"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> tree(@PathVariable(value="tenantKey") String var1);

    default public <T extends OrgDto<T>> ResponseEntity<T> tree(long tenantId) {
        return this.tree(String.valueOf(tenantId));
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u5220\u9664\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2);

    default public ResponseEntity<String> delete(long tenantId, long orgId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(orgId));
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ec4\u7ec7\u5b50\u5b59", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/descendants"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<List<T>> descendants(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2);

    default public <T extends OrgDto<T>> ResponseEntity<List<T>> descendants(long tenantId, long orgId) {
        return this.descendants(String.valueOf(tenantId), String.valueOf(orgId));
    }

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs";
        public static final String list = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs";
        public static final String batchImportChildrenIntoParent = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{parentKey}/batch";
        public static final String batchImportWithResult = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch-with-result";
        public static final String batchImport = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}";
        public static final String updateStatus = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/status/{status}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}";
        public static final String tree = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/tree";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}";
        public static final String descendants = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/descendants";
        public static final String batch_import = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/excel";
    }
}

