/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public interface UserApi {
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap UserModel.Request.Query var2, Pageable var3);

    default public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> page(long tenantId, UserModel.Request.Query query, Pageable pageable) {
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/list"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<List<T>> list(@PathVariable(value="tenantKey") String var1, @SpringQueryMap UserModel.Request.Query var2, Sort var3);

    default public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<List<T>> list(long tenantId, UserModel.Request.Query query, Sort sort) {
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users"}, method={RequestMethod.POST})
    public <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<U> create(@PathVariable(value="tenantKey") String var1, @RequestBody @Valid UserModel.Request.Create var2);

    default public <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<U> create(long tenantId, UserModel.Request.Create model) {
        return this.create(String.valueOf(tenantId), model);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/batch"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImport(@PathVariable(value="tenantKey") String var1, @RequestBody @Valid UserModel.Request.BatchImport var2);

    default public ResponseEntity<Boolean> batchImport(long tenantId, UserModel.Request.BatchImport batchImport) {
        return this.batchImport(String.valueOf(tenantId), batchImport);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5f80\u7ec4\u7ec7\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/users/batch"}, method={RequestMethod.POST})
    public <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<UserModel.Request.SaveUserOutput<U, O, R, A, E>> batchImportIntoOrg(@PathVariable(value="tenantKey") String var1, @PathVariable(value="orgKey") String var2, @RequestBody @Valid @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid UserModel.Request.Create> var3);

    default public <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<UserModel.Request.SaveUserOutput<U, O, R, A, E>> batchImportIntoOrg(long tenantId, long orgId, List<UserModel.Request.Create> models) {
        return this.batchImportIntoOrg(String.valueOf(tenantId), String.valueOf(orgId), models);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}"}, method={RequestMethod.PUT})
    public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestBody UserModel.Request.Update var3);

    default public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> update(long tenantId, long userId, UserModel.Request.Update model) {
        return this.update(String.valueOf(tenantId), String.valueOf(userId), model);
    }

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var3);

    default public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> info(long tenantId, long userId, int extraInfoDimension) {
        return this.info(String.valueOf(tenantId), String.valueOf(userId), extraInfoDimension);
    }

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2);

    default public ResponseEntity<String> delete(long tenantId, long userId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(userId));
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindRoles(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestBody UserModel.Request.BindRoles var3);

    default public ResponseEntity<String> bindRoles(long tenantId, long userId, UserModel.Request.BindRoles bindRoles) {
        return this.bindRoles(String.valueOf(tenantId), String.valueOf(userId), bindRoles);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u53cd\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindRoles(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestBody UserModel.Request.UnbindRoles var3);

    default public ResponseEntity<String> unbindRoles(long tenantId, long userId, UserModel.Request.UnbindRoles unbindRoles) {
        return this.unbindRoles(String.valueOf(tenantId), String.valueOf(userId), unbindRoles);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindOrgs(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestBody UserModel.Request.BindOrgs var3);

    default public ResponseEntity<String> bindOrgs(long tenantId, long userId, UserModel.Request.BindOrgs bindOrgs) {
        return this.bindOrgs(String.valueOf(tenantId), String.valueOf(userId), bindOrgs);
    }

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u53cd\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindOrgs(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestBody UserModel.Request.UnbindOrgs var3);

    default public ResponseEntity<String> unbindOrgs(long tenantId, long userId, UserModel.Request.UnbindOrgs unbindOrgs) {
        return this.unbindOrgs(String.valueOf(tenantId), String.valueOf(userId), unbindOrgs);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    default public ResponseEntity<String> updateStatus(long tenantId, long userId, int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(userId), status);
    }

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u4e0b\u7528\u6237\u7684\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> userResources(@PathVariable(value="tenantKey") String var1, @PathVariable(value="userKey") String var2, @RequestParam(value="loginId", required=false) String var3);

    default public ResponseEntity<Set<String>> userResources(long tenantId, long userId, String loginId) {
        return this.userResources(String.valueOf(tenantId), String.valueOf(userId), loginId);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/batch/import"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> batchImportFromExcel(@PathVariable(value="tenantKey") String var1, @RequestParam(value="file") MultipartFile var2);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users";
        public static final String list = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users";
        public static final String batchImport = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/batch";
        public static final String batchImport2 = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/batch/import";
        public static final String batchImportIntoOrg = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/orgs/{orgKey}/users/batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}";
        public static final String resources = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/resources";
        public static final String user_bind_roles = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles";
        public static final String user_unbind_roles = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles/unbind";
        public static final String user_bind_orgs = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs";
        public static final String user_unbind_orgs = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/orgs/unbind";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/status/{status}";
    }
}

