/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import javax.validation.Valid;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public interface RoleApi {
    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles"}, method={RequestMethod.GET})
    public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<Page<T>> page(@PathVariable(value="tenantKey") String var1, @SpringQueryMap RoleModel.Request.Query var2, Pageable var3);

    default public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<Page<T>> page(long tenantId, RoleModel.Request.Query query, Pageable pageable) {
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles"}, method={RequestMethod.POST})
    public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> create(@PathVariable(value="tenantKey") String var1, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) RoleModel.Request.Create var2);

    default public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> create(long tenantId, RoleModel.Request.Create model) {
        return this.create(String.valueOf(tenantId), model);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/batch"}, method={RequestMethod.POST})
    public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<List<T>> batchCreate(@PathVariable(value="tenantKey") String var1, @RequestBody List<RoleModel.Request.Save> var2);

    default public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<List<T>> batchCreate(long tenantId, List<RoleModel.Request.Save> models) {
        return this.batchCreate(String.valueOf(tenantId), models);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u7ed1\u5b9a\u529f\u80fd\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/resource-sets"}, method={RequestMethod.POST})
    public ResponseBoolenEntity<Boolean, RoleModel.Request.BindResourceSet> bindResourceSets(@PathVariable(value="tenantKey") String var1, @RequestBody @Valid List<RoleModel.Request.BindResourceSet> var2);

    default public ResponseBoolenEntity<Boolean, RoleModel.Request.BindResourceSet> bindResourceSets(long tenantId, List<RoleModel.Request.BindResourceSet> bindResourceSets) {
        return this.bindResourceSets(String.valueOf(tenantId), bindResourceSets);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}"}, method={RequestMethod.PUT})
    public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> update(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestBody @Valid RoleModel.Request.Update var3);

    default public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> update(long tenantId, long roleId, RoleModel.Request.Update model) {
        return this.update(String.valueOf(tenantId), String.valueOf(roleId), model);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    default public ResponseEntity<String> updateStatus(long tenantId, long roleId, int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(roleId), status);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}"}, method={RequestMethod.GET})
    public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> info(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2);

    default public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> info(long tenantId, long roleId) {
        return this.info(String.valueOf(tenantId), String.valueOf(roleId));
    }

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2);

    default public ResponseEntity<String> delete(long tenantId, long roleId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(roleId));
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> users(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @SpringQueryMap UserModel.Request.Query var3, Pageable var4);

    default public <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> users(long tenantId, long roleId, UserModel.Request.Query query, Pageable pageable) {
        return this.users(String.valueOf(tenantId), String.valueOf(roleId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/resources"}, method={RequestMethod.GET})
    public <T extends ResourceDto<T>> ResponseEntity<Page<T>> resources(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, Pageable var3);

    default public <T extends ResourceDto<T>> ResponseEntity<Page<T>> resources(long tenantId, long roleId, Pageable pageable) {
        return this.resources(String.valueOf(tenantId), String.valueOf(roleId), pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindUsers(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestBody RoleModel.Request.BindUsers var3);

    default public ResponseEntity<String> bindUsers(long tenantId, long roleId, RoleModel.Request.BindUsers bindUsers) {
        return this.bindUsers(String.valueOf(tenantId), String.valueOf(roleId), bindUsers);
    }

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u6279\u91cf\u53cd\u7ed1\u5b9a\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> unbindUsers(@PathVariable(value="tenantKey") String var1, @PathVariable(value="roleKey") String var2, @RequestBody RoleModel.Request.UnbindUsers var3);

    default public ResponseEntity<String> unbindUsers(long tenantId, long roleId, RoleModel.Request.UnbindUsers unbindUsers) {
        return this.unbindUsers(String.valueOf(tenantId), String.valueOf(roleId), unbindUsers);
    }

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u5173\u8054\u8d26\u53f7\u548c\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/bind/users"}, method={RequestMethod.POST})
    public <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> batchImportBind(@PathVariable(value="tenantKey") String var1, @RequestParam(value="file") MultipartFile var2);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles";
        public static final String list = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles";
        public static final String batchCreate = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/status/{status}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}";
        public static final String users = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users";
        public static final String resources = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/resources";
        public static final String bindResourceSet = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/resource-sets";
        public static final String bindUsers = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users";
        public static final String unbindUsers = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/{roleKey}/users/unbind";
        public static final String batch_import = "${xforce.tenant.service.url.prefix:}/{tenantKey}${xforce.tenant.service.version:}/roles/bind/users";
    }
}

