package com.xforceplus.api.tenant.company;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.CompanyModel.Request.*;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.validation.ValidationGroup;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 公司相关接口 (tenant)
 *
 * @author geewit
 */
public interface CompanyApi {
    @ResponseBody
    @RequestMapping(name = "公司列表", value = Path.page, method = RequestMethod.GET)
    <T extends CompanyDto> ResponseEntity<Page<T>> page(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                        @SpringQueryMap Query query,
                                                        Pageable pageable);

    @ResponseBody
    @RequestMapping(name = "公司信息", value = Path.info, method = RequestMethod.GET)
    <T extends CompanyDto> ResponseEntity<T> info(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                  @PathVariable("companyId") @Valid @Min(1) long companyId,
                                                  @RequestParam(value = "withExtendParams", required = false) String withExtendParams);

    @ResponseBody
    @RequestMapping(name = "新增公司", value = Path.create, method = RequestMethod.POST)
    <T extends CompanyDto> ResponseEntity<T> create(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                    @RequestBody @Validated(ValidationGroup.OnCreate.class) Save company);

    @ResponseBody
    @RequestMapping(name = "更新公司", value = Path.update, method = RequestMethod.PUT)
    <T extends CompanyDto> ResponseEntity<T> update(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                    @PathVariable("companyId") @Valid @Min(1) long companyId,
                                                    @RequestBody @Validated(ValidationGroup.OnUpdate.class) Save company);


    @ResponseBody
    @RequestMapping(name = "公司绑定服务包", value = Path.bind_packages, method = RequestMethod.POST)
    ResponseEntity<String> bindPackages(
            @PathVariable("tenantId") @Valid @Min(1) long tenantId,
            @PathVariable("companyId") @Valid @Min(1) long companyId,
            @RequestBody BindPackages bindPackage);

    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/companies";
        String list = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/companies/list";
        String info = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/companies/{companyId}";
        String create = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/companies";
        String update = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/companies/{companyId}";
        String bind_packages = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/companies/{companyId}/packages";
    }
}
