package com.xforceplus.api.tenant.org;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgModel.Request.Query;
import com.xforceplus.api.model.OrgModel.Request.Save;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.validation.ValidationGroup;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 组织相关接口 (tenant)
 *
 * @author geewit
 */
public interface OrgApi {
    @ResponseBody
    @RequestMapping(name = "租户组织分页列表", value = Path.page, method = RequestMethod.GET)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<Page<O>> page(@PathVariable("tenantKey") String tenantKey,
                                                                                     @SpringQueryMap Query query,
                                                                                     Pageable pageable);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<Page<O>> page(long tenantId,
                                                               Query query,
                                                               Pageable pageable) {
        return this.page(String.valueOf(tenantId), query, pageable);
    }


    @ResponseBody
    @RequestMapping(name = "租户组织列表", value = Path.list, method = RequestMethod.GET)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<List<O>> list(@PathVariable("tenantKey") String tenantKey,
                                                       @SpringQueryMap Query query,
                                                       Sort sort);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<List<O>> list(long tenantId,
                                                               Query query,
                                                               Sort sort) {
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name = "租户新增组织", value = Path.create, method = RequestMethod.POST)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> create(@PathVariable("tenantKey") String tenantKey,
                                                   @RequestBody @Validated(ValidationGroup.OnCreate.class) Save model);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> create(long tenantId,
                                                           Save model) {
        return this.create(String.valueOf(tenantId), model);
    }

    @ResponseBody
    @RequestMapping(name = "租户向指定父组织批量导入组织", value = Path.batchImportChildrenIntoParent, method = RequestMethod.POST)
    ResponseEntity<Boolean> batchImportChildrenIntoParent(@PathVariable("tenantKey") String tenantKey,
                                                          @PathVariable("parentKey") String parentKey,
                                                          @RequestBody @Validated(ValidationGroup.OnCreate.class) List<@Valid Save> models);

    default ResponseEntity<Boolean> batchImportChildrenIntoParent(long tenantId,
                                                                  long parentId,
                                                                  List<Save> models) {
        return this.batchImportChildrenIntoParent(String.valueOf(tenantId), String.valueOf(parentId), models);
    }

    @ResponseBody
    @RequestMapping(name = "租户批量导入组织", value = Path.batchImport, method = RequestMethod.POST)
    ResponseEntity<Boolean> batchImport(@PathVariable("tenantKey") String tenantKey,
                                        @RequestBody @Validated(ValidationGroup.OnCreate.class) List<@Valid Save> models);

    default ResponseEntity<Boolean> batchImport(long tenantId,
                                                List<Save> models) {
        return this.batchImport(String.valueOf(tenantId), models);
    }

    @ResponseBody
    @RequestMapping(name = "租户批量导入组织", value = Path.batchImportWithResult, method = RequestMethod.POST)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseBoolenEntity<Boolean, O> batchImportWithResult(@PathVariable("tenantKey") String tenantKey,
                                                                                 @RequestBody @Validated(ValidationGroup.OnCreate.class) List<@Valid Save> models);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseBoolenEntity<Boolean, O> batchImportWithResult(long tenantId,
                                                                                         List<Save> models) {
        return this.batchImportWithResult(String.valueOf(tenantId), models);
    }

    @ResponseBody
    @RequestMapping(name = "租户更新组织", value = Path.update, method = RequestMethod.PUT)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> update(@PathVariable("tenantKey") String tenantKey,
                                                   @PathVariable("orgKey") String orgKey,
                                                   @RequestBody Save org);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> update(long tenantId,
                                                           long orgId,
                                                           Save org) {
        return this.update(String.valueOf(tenantId), String.valueOf(orgId), org);
    }

    @ResponseBody
    @RequestMapping(name = "租户更新组织状态", value = Path.updateStatus, method = RequestMethod.PATCH)
    ResponseEntity<String> updateStatus(@PathVariable("tenantKey") String tenantKey,
                                        @PathVariable("orgKey") String orgKey,
                                        @PathVariable("status") @Valid @Range(max = 1) int status);

    default ResponseEntity<String> updateStatus(long tenantId,
                                                long orgId,
                                                int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(orgId), status);
    }

    @ResponseBody
    @RequestMapping(name = "租户组织信息", value = Path.info, method = RequestMethod.GET)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> info(@PathVariable("tenantKey") String tenantKey,
                                                 @PathVariable("orgKey") String orgKey);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> info(long tenantId,
                                                         long orgId) {
        return this.info(String.valueOf(tenantId), String.valueOf(orgId));
    }

    @ResponseBody
    @RequestMapping(name = "租户组织树", value = Path.tree, method = RequestMethod.GET)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> tree(@PathVariable("tenantKey") String tenantKey, @RequestParam("status") @Valid @Range(max = 1L) Integer status);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<O> tree(long tenantId, Integer status) {
        return this.tree(String.valueOf(tenantId), status);
    }

//    @ResponseBody
//    @RequestMapping(name = "租户删除组织", value = Path.delete, method = RequestMethod.DELETE)
//    ResponseEntity<String> delete(@PathVariable("tenantKey") String tenantKey,
//                                  @PathVariable("orgKey") String orgKey);
//
//    default ResponseEntity<String> delete(long tenantId,
//                                  long orgId) {
//        return this.delete(String.valueOf(tenantId), String.valueOf(orgId));
//    }

    @ResponseBody
    @RequestMapping(name = "租户组织子孙", value = Path.descendants, method = RequestMethod.GET)
    <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<List<O>> descendants(@PathVariable("tenantKey") String tenantKey,
                                                              @PathVariable("orgKey") String orgKey);

    default <O extends OrgDto<O, E>, E extends OrgExtensionDto> ResponseEntity<List<O>> descendants(long tenantId,
                                                                      long orgId) {
        return this.descendants(String.valueOf(tenantId), String.valueOf(orgId));
    }



    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs";
        String list = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/list";
        String create = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs";
        String batchImportChildrenIntoParent = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{parentKey}/batch";
        String batchImportWithResult = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/batch-with-result";
        String batchImport = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/batch";
        String update = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}";
        String updateStatus = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}/status/{status}";
        String info = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}";
        String tree = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/tree";
        String delete = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}";
        String descendants = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}/descendants";
        String batch_import = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/excel";

    }
}
