package com.xforceplus.api.tenant.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourceModel.Request.Query;
import com.xforceplus.domain.resource.ResourceDto;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 资源码相关接口 (global)
 *
 * @author geewit
 */
public interface ResourceApi {
    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/resources";
    }

    @ResponseBody
    @RequestMapping(name = "资源码分页列表", value = Path.page, method = RequestMethod.GET)
    <T extends ResourceDto<T>> ResponseEntity<Page<T>> page(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                            @SpringQueryMap Query query,
                                                            Pageable pageable);

}
