package com.xforceplus.api.tenant.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourcesetModel.Request.Query;
import com.xforceplus.domain.resource.ResourcesetDto;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 功能集相关接口 (global)
 *
 * @author geewit
 */
public interface ResourcesetApi {
    @ResponseBody
    @RequestMapping(name = "功能集分页列表", value = Path.page, method = RequestMethod.GET)
    <T extends ResourcesetDto> ResponseEntity<Page<T>> page(@PathVariable("tenantId") @Valid @Min(1) long tenantId,
                                                            @SpringQueryMap Query query,
                                                            Pageable pageable);

    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/resourcesets";
    }
}
