package com.xforceplus.api.tenant.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ServiceApiModel.Request.Query;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ServiceApiDto;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;
import javax.validation.constraints.Min;


/**
 * 服务接口相关接口 (global)
 *
 * @author geewit
 */
public interface ServiceApiApi {
    @ResponseBody
    @RequestMapping(name = "租户关联服务包接口分页列表", value = Path.page, method = RequestMethod.GET)
    <T extends ServiceApiDto> ResponseEntity<Page<T>> page(
            @PathVariable("tenantId") @Valid @Min(1) long tenantId,
            @SpringQueryMap Query query,
            Pageable pageable);

    @ResponseBody
    @RequestMapping(name = "租户关联服务包接口信息", value = Path.info, method = RequestMethod.GET)
    <T extends ServiceApiDto> ResponseEntity<T> info(
            @PathVariable("tenantId") @Valid @Min(1) long tenantId,
            @PathVariable("id") @Valid @Min(1) long id);


    @ResponseBody
    @RequestMapping(name = "租户关联服务包接口对应的资源码分页列表", value = Path.resources, method = RequestMethod.GET)
    <T extends ResourceDto<T>> ResponseEntity<Page<T>> resources(
            @PathVariable("tenantId") @Valid @Min(1) long tenantId,
            @PathVariable("id") @Valid @Min(1) long id,
            Pageable pageable);


    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/service-apis";
        String info = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/service-apis/{id}";
        String resources = Uri.PATH_PREFIX + "/{tenantId}" + Uri.API_VERSION + "/service-apis/{id}/resources";
    }
}
