package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.RoleModel.Request.*;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

/**
 * 角色相关接口 (tenant)
 *
 * @author geewit
 */
public interface RoleApi {


    @ResponseBody
    @RequestMapping(name = "角色分页列表", value = Path.page, method = RequestMethod.GET)
    <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<Page<T>> page(@PathVariable("tenantKey") String tenantKey,
                                                     @SpringQueryMap Query query,
                                                     Pageable pageable);

    default <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<Page<T>> page(long tenantId,
                                                                                            Query query,
                                                                                            Pageable pageable) {
        return this.page(String.valueOf(tenantId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name = "新增角色", value = Path.create, method = RequestMethod.POST)
    <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> create(@PathVariable("tenantKey") String tenantKey,
                                                 @RequestBody @Validated(ValidationGroup.OnCreate.class) Create model);

    default <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> create(long tenantId,
                                                         Create model) {
        return this.create(String.valueOf(tenantId), model);
    }

    @ResponseBody
    @RequestMapping(name = "新增角色", value = Path.batchCreate, method = RequestMethod.POST)
    <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<List<T>> batchCreate(@PathVariable("tenantKey") String tenantKey,
                                      @RequestBody List<Save> models);

    default <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<List<T>> batchCreate(long tenantId,
                                              List<Save> models) {
        return this.batchCreate(String.valueOf(tenantId), models);
    }

    @ResponseBody
    @RequestMapping(name = "批量绑定功能集合", value = Path.bindResourceSet, method = RequestMethod.POST)
    ResponseBoolenEntity<Boolean, BindResourceSet> bindResourceSets(@PathVariable("tenantKey") String tenantKey,
                                                                    @RequestBody  @Valid  List<BindResourceSet> bindResourceSets);

    default ResponseBoolenEntity<Boolean, BindResourceSet> bindResourceSets(long tenantId,
                                                                            List<BindResourceSet> bindResourceSets) {
        return this.bindResourceSets(String.valueOf(tenantId), bindResourceSets);
    }

    @ResponseBody
    @RequestMapping(name = "更新角色", value = Path.update, method = RequestMethod.PUT)
    <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> update(@PathVariable("tenantKey") String tenantKey,
                                                 @PathVariable("roleKey") String roleKey,
                                                 @RequestBody @Valid Update model);

    default <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> update(long tenantId,
                                                         long roleId,
                                                         Update model) {
        return this.update(String.valueOf(tenantId), String.valueOf(roleId), model);
    }

    @ResponseBody
    @RequestMapping(name = "更新角色状态", value = Path.update_status, method = RequestMethod.PATCH)
    ResponseEntity<String> updateStatus(@PathVariable("tenantKey") String tenantKey,
                                        @PathVariable("roleKey") String roleKey,
                                        @PathVariable("status") @Valid @Range(max = 1L) int status);

    default ResponseEntity<String> updateStatus(long tenantId,
                                                long roleId,
                                                int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(roleId), status);
    }

    @ResponseBody
    @RequestMapping(name = "角色信息", value = Path.info, method = RequestMethod.GET)
    <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> info(@PathVariable("tenantKey") String tenantKey,
                                               @PathVariable("roleKey") String roleKey);

    default <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> info(long tenantId,
                                                       long roleId) {
        return this.info(String.valueOf(tenantId), String.valueOf(roleId));
    }

    @ResponseBody
    @RequestMapping(name = "删除角色", value = Path.delete, method = RequestMethod.DELETE)
    ResponseEntity<String> delete(@PathVariable("tenantKey") String tenantKey,
                                  @PathVariable("roleKey") String roleKey);

    default ResponseEntity<String> delete(long tenantId,
                                          long roleId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(roleId));
    }

    @ResponseBody
    @RequestMapping(name = "角色用户列表", value = Path.users, method = RequestMethod.GET)
    <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> users(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("roleKey") String roleKey,
            @SpringQueryMap UserModel.Request.Query query,
            Pageable pageable);

    default <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> users(
            long tenantId,
            long roleId,
            UserModel.Request.Query query,
            Pageable pageable) {
        return this.users(String.valueOf(tenantId), String.valueOf(roleId), query, pageable);
    }

    @ResponseBody
    @RequestMapping(name = "角色资源码列表", value = Path.resources, method = RequestMethod.GET)
    <T extends ResourceDto<T>> ResponseEntity<Page<T>> resources(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("roleKey") String roleKey,
            Pageable pageable);

    default <T extends ResourceDto<T>> ResponseEntity<Page<T>> resources(
            long tenantId,
            long roleId,
            Pageable pageable) {
        return this.resources(String.valueOf(tenantId), String.valueOf(roleId), pageable);
    }

    @ResponseBody
    @RequestMapping(name = "角色批量绑定用户", value = Path.bindUsers, method = RequestMethod.POST)
    ResponseEntity<String> bindUsers(@PathVariable("tenantKey") String tenantKey,
                                     @PathVariable("roleKey") String roleKey,
                                     @RequestBody BindUsers bindUsers);


    default ResponseEntity<String> bindUsers(long tenantId,
                                             long roleId,
                                             BindUsers bindUsers) {
        return this.bindUsers(String.valueOf(tenantId), String.valueOf(roleId), bindUsers);
    }

    @ResponseBody
    @RequestMapping(name = "角色批量反绑定用户", value = Path.unbindUsers, method = RequestMethod.POST)
    ResponseEntity<String> unbindUsers(@PathVariable("tenantKey") String tenantKey,
                                     @PathVariable("roleKey") String roleKey,
                                     @RequestBody UnbindUsers unbindUsers);


    default ResponseEntity<String> unbindUsers(long tenantId,
                                             long roleId,
                                               UnbindUsers unbindUsers) {
        return this.unbindUsers(String.valueOf(tenantId), String.valueOf(roleId), unbindUsers);
    }

    @ResponseBody
    @RequestMapping(name = "批量导入关联账号和角色", value = Path.batch_import, method = RequestMethod.POST)
    <T extends RoleDto<RS>, RS extends ResourcesetDto> ResponseEntity<T> batchImportBind(@PathVariable("tenantKey") String tenantKey, @RequestParam("file") MultipartFile file);



    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles";
        String list = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/list";
        String create = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles";
        String batchCreate = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/batch";
        String update = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}";
        String update_status = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}/status/{status}";
        String info = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}";
        String delete = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}";
        String users = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}/users";
        String resources = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}/resources";
        String bindResourceSet = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/resource-sets";
        String bindUsers = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}/users";
        String unbindUsers = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/{roleKey}/users/unbind";
        String batch_import = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/roles/bind/users";
    }
}
