package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel.Request.*;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;
import java.util.Set;

/**
 * 租户的用户接口 (tenant)
 *
 * @author geewit
 */
public interface UserApi {
    @ResponseBody
    @RequestMapping(name = "用户列表", value = Path.page, method = RequestMethod.GET)
    <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> page(@PathVariable("tenantKey") String tenantKey,
                                                                                                                                                       @SpringQueryMap Query query,
                                                                                                                                                       Pageable pageable);

    default <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<Page<T>> page(long tenantId,
                                                                                                                                    Query query,
                                                                                                                                    Pageable pageable) {
        return this.page(String.valueOf(tenantId), query, pageable);
    }


    @ResponseBody
    @RequestMapping(name = "用户列表", value = Path.list, method = RequestMethod.GET)
    <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<List<T>> list(@PathVariable("tenantKey") String tenantKey,
                                                                                                                            @SpringQueryMap Query query,
                                                                                                                            Sort sort);

    default <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<List<T>> list(long tenantId,
                                                                                                                                    Query query,
                                                                                                                                    Sort sort) {
        return this.list(String.valueOf(tenantId), query, sort);
    }

    @ResponseBody
    @RequestMapping(name = "新增用户", value = Path.create, method = RequestMethod.POST)
    <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<U> create(@PathVariable("tenantKey") String tenantKey,
                                                                                                                        @RequestBody @Valid Create model);

    default <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<U> create(long tenantId,
                                                                                                                                Create model) {
        return this.create(String.valueOf(tenantId), model);
    }

    @ResponseBody
    @RequestMapping(name = "批量导入用户", value = Path.batchImport, method = RequestMethod.POST)
    ResponseEntity<Boolean> batchImport(@PathVariable("tenantKey") String tenantKey,
                                        @RequestBody @Valid BatchImport batchImport);


    default ResponseEntity<Boolean> batchImport(long tenantId,
                                                BatchImport batchImport) {
        return this.batchImport(String.valueOf(tenantId), batchImport);
    }

    @ResponseBody
    @RequestMapping(name = "批量往组织导入用户", value = Path.batchImportIntoOrg, method = RequestMethod.POST)
    <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<SaveUserOutput<U, O, R, A, E>> batchImportIntoOrg(@PathVariable("tenantKey") String tenantKey,
                                                                                                                                                             @PathVariable("orgKey") String orgKey,
                                                                                                                                                             @RequestBody @Valid List<@Valid Create> models);

    default <O extends OrgDto<O, E>, U extends UserDto<O, R, A, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<SaveUserOutput<U, O, R, A, E>> batchImportIntoOrg(long tenantId,
                                                                                                                                                                     long orgId,
                                                                                                                                                                     List<Create> models) {
        return this.batchImportIntoOrg(String.valueOf(tenantId), String.valueOf(orgId), models);
    }

    @ResponseBody
    @RequestMapping(name = "更新用户", value = Path.update, method = RequestMethod.PUT)
    <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> update(@PathVariable("tenantKey") String tenantKey,
                                                                                                                        @PathVariable("userKey") String userKey,
                                                                                                                        @RequestBody Update model);

    default <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> update(long tenantId,
                                                                                                                                long userId,
                                                                                                                                Update model) {
        return this.update(String.valueOf(tenantId), String.valueOf(userId), model);
    }

    @ResponseBody
    @RequestMapping(name = "获取用户信息", value = Path.info, method = RequestMethod.GET)
    <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> info(@PathVariable("tenantKey") String tenantKey,
                                                                                                                      @PathVariable("userKey") String userKey,
                                                                                                                      @RequestParam(value = "extraInfo", required = false, defaultValue = "0") int extraInfoDimension);

    default <T extends UserDto<O, R, A, E>, O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> ResponseEntity<T> info(long tenantId,
                                                                                                                              long userId,
                                                                                                                              int extraInfoDimension) {
        return this.info(String.valueOf(tenantId), String.valueOf(userId), extraInfoDimension);
    }

    @ResponseBody
    @RequestMapping(name = "删除用户", value = Path.delete, method = RequestMethod.DELETE)
    ResponseEntity<String> delete(@PathVariable("tenantKey") String tenantKey,
                                  @PathVariable("userKey") String userKey);

    default ResponseEntity<String> delete(long tenantId,
                                          long userId) {
        return this.delete(String.valueOf(tenantId), String.valueOf(userId));
    }

    @ResponseBody
    @RequestMapping(name = "用户绑定角色列表", value = Path.user_bind_roles, method = RequestMethod.POST)
    ResponseEntity<String> bindRoles(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestBody BindRoles bindRoles);

    default ResponseEntity<String> bindRoles(
            long tenantId,
            long userId,
            BindRoles bindRoles) {
        return this.bindRoles(String.valueOf(tenantId), String.valueOf(userId), bindRoles);
    }


    @ResponseBody
    @RequestMapping(name = "用户反绑定角色列表", value = Path.user_unbind_roles, method = RequestMethod.POST)
    ResponseEntity<String> unbindRoles(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestBody UnbindRoles unbindRoles);

    default ResponseEntity<String> unbindRoles(
            long tenantId,
            long userId,
            UnbindRoles unbindRoles) {
        return this.unbindRoles(String.valueOf(tenantId), String.valueOf(userId), unbindRoles);
    }

    @ResponseBody
    @RequestMapping(name = "用户绑定组织列表", value = Path.user_bind_orgs, method = RequestMethod.POST)
    ResponseEntity<String> bindOrgs(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestBody BindOrgs bindOrgs);

    default ResponseEntity<String> bindOrgs(
            long tenantId,
            long userId,
            BindOrgs bindOrgs) {
        return this.bindOrgs(String.valueOf(tenantId), String.valueOf(userId), bindOrgs);
    }

    @ResponseBody
    @RequestMapping(name = "用户反绑定组织列表", value = Path.user_unbind_orgs, method = RequestMethod.POST)
    ResponseEntity<String> unbindOrgs(
            @PathVariable("tenantKey") String tenantKey,
            @PathVariable("userKey") String userKey,
            @RequestBody UnbindOrgs unbindOrgs);

    default ResponseEntity<String> unbindOrgs(
            long tenantId,
            long userId,
            UnbindOrgs unbindOrgs) {
        return this.unbindOrgs(String.valueOf(tenantId), String.valueOf(userId), unbindOrgs);
    }

    @ResponseBody
    @RequestMapping(name = "更新用户状态", value = Path.update_status, method = RequestMethod.PATCH)
    ResponseEntity<String> updateStatus(@PathVariable("tenantKey") String tenantKey,
                                        @PathVariable("userKey") String userKey,
                                        @PathVariable("status") @Valid @Range(max = 1L) int status);

    default ResponseEntity<String> updateStatus(long tenantId,
                                                long userId,
                                                int status) {
        return this.updateStatus(String.valueOf(tenantId), String.valueOf(userId), status);
    }

    @ResponseBody
    @RequestMapping(name = "租户下用户的资源码集合", value = Path.resources, method = RequestMethod.GET)
    ResponseEntity<Set<String>> userResources(@PathVariable("tenantKey") String tenantKey, @PathVariable("userKey") String userKey, @RequestParam(value = "loginId", required = false) String loginId);


    default ResponseEntity<Set<String>> userResources(long tenantId, long userId, String loginId) {
        return this.userResources(String.valueOf(tenantId), String.valueOf(userId), loginId);
    }



    @ResponseBody
    @RequestMapping(name = "批量导入用户", value = Path.batchImport2, method = RequestMethod.POST)
    ResponseEntity<Boolean> batchImportFromExcel(@PathVariable("tenantKey") String tenantKey, @RequestParam("file") MultipartFile file);


    interface Path extends Uri {
        String page = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users";
        String list = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/list";
        String create = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users";
        String batchImport = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/batch";
        String batchImport2 = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/batch/import";
        String batchImportIntoOrg = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/orgs/{orgKey}/users/batch";
        String update = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}";
        String info = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}";
        String delete = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}";
        String resources = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}/resources";
        String user_bind_roles = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}/roles";
        String user_unbind_roles = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}/roles/unbind";
        String user_bind_orgs = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}/orgs";
        String user_unbind_orgs = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}/orgs/unbind";
        String update_status = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION + "/users/{userKey}/status/{status}";

    }

}
