package com.xforceplus.domain.route;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AuthorizationInfo {
    @JsonProperty("name")
    private String name;
    @JsonProperty("methodName")
    private String methodName;
    @JsonProperty("isWithoutAuth")
    private boolean isWithoutAuth;
    @JsonProperty("isSkipAuth")
    private boolean isSkipAuth;
    @JsonProperty("resources")
    private Set<String> resources;

    public AuthorizationInfo() {
    }

    public AuthorizationInfo(String name, String methodName, String... resources) {
        this(name, methodName, false, resources);
    }

    public AuthorizationInfo(String name, String methodName, boolean isWithoutAuth, String... resources) {
        this.name = name;
        this.methodName = methodName;
        this.isWithoutAuth = isWithoutAuth;
        if (resources != null) {
            this.resources = new HashSet(resources.length);
            Collections.addAll(this.resources, resources);
        }

    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean getIsWithoutAuth() {
        return this.isWithoutAuth;
    }

    public void setIsWithoutAuth(boolean skipAuth) {
        this.isWithoutAuth = skipAuth;
    }

    public boolean getIsSkipAuth() {
        return isSkipAuth;
    }

    public void setIsSkipAuth(boolean skipAuth) {
        isSkipAuth = skipAuth;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public void setResources(Set<String> resources) {
        this.resources = resources;
    }
}
