/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.config;

import com.fasterxml.jackson.databind.Module;
import com.xforceplus.tenant.core.exception.ErrorCodes;
import com.xforceplus.tenant.core.exception.TenantFeignException;
import com.xforceplus.tenant.core.exception.response.ErrorResponse;
import com.xforceplus.tenant.security.client.interceptor.TenantTokenRequestInterceptor;
import com.xforceplus.tenant.security.client.interceptor.UserContextFeignInterceptor;
import com.xforceplus.tenant.security.client.service.ClientService;
import com.xforceplus.tenant.security.client.support.OauthClientProperties;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.FeignException;
import feign.Response;
import feign.Retryer;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.optionals.OptionalDecoder;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.cloud.openfeign.support.PageJacksonModule;
import org.springframework.cloud.openfeign.support.PageableSpringEncoder;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestTemplate;

@AutoConfigureAfter(value={FeignAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OauthClientProperties.class})
public class TenantFeignConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TenantFeignConfiguration.class);
    private final ObjectFactory<HttpMessageConverters> messageConverters;
    @Autowired(required=false)
    private List<AnnotatedParameterProcessor> parameterProcessors = new ArrayList<AnnotatedParameterProcessor>();
    @Autowired(required=false)
    private List<FeignFormatterRegistrar> feignFormatterRegistrars = new ArrayList<FeignFormatterRegistrar>();
    @Autowired(required=false)
    private SpringDataWebProperties springDataWebProperties;

    public TenantFeignConfiguration(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
        logger.info("TenantFeignConfiguration initializing");
    }

    @Bean
    @ConditionalOnMissingBean
    public Decoder feignDecoder() {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder((Decoder)new SpringDecoder(this.messageConverters)));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.domain.Pageable"})
    public Encoder feignEncoder() {
        return new SpringEncoder(this.messageConverters);
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorDecoder errorDecoder() {
        return (methodKey, response) -> {
            String body;
            logger.info("feign client response:", (Object)response);
            try {
                body = Util.toString((Reader)response.body().asReader());
            }
            catch (IOException e) {
                logger.error("feign.IOException", (Throwable)e);
                throw new TenantFeignException(ErrorCodes.NOT_FOUND.getMessage(), ErrorCodes.NOT_FOUND.getCode(), response.status());
            }
            ErrorResponse errorResponse = (ErrorResponse)JsonUtils.fromJson((String)body, ErrorResponse.class);
            if (response.status() >= HttpStatus.BAD_REQUEST.value() && response.status() <= HttpStatus.INTERNAL_SERVER_ERROR.value()) {
                throw new TenantFeignException(errorResponse.getMessage(), errorResponse.getCode(), response.status());
            }
            return FeignException.errorStatus((String)methodKey, (Response)response);
        };
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean
    public PageableSpringEncoder feignEncoderPageable() {
        PageableSpringEncoder encoder = new PageableSpringEncoder((Encoder)new SpringEncoder(this.messageConverters));
        if (this.springDataWebProperties != null) {
            encoder.setPageParameter(this.springDataWebProperties.getPageable().getPageParameter());
            encoder.setSizeParameter(this.springDataWebProperties.getPageable().getSizeParameter());
            encoder.setSortParameter(this.springDataWebProperties.getSort().getSortParameter());
        }
        return encoder;
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Page"})
    public Module pageJacksonModule() {
        return new PageJacksonModule();
    }

    @Bean
    @ConditionalOnMissingBean
    public Contract feignContract(ConversionService feignConversionService) {
        return new SpringMvcContract(this.parameterProcessors, feignConversionService);
    }

    @Bean
    @ConditionalOnMissingBean
    public FormattingConversionService feignConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.feignFormatterRegistrars.forEach(arg_0 -> TenantFeignConfiguration.lambda$feignConversionService$1((FormattingConversionService)conversionService, arg_0));
        return conversionService;
    }

    @Bean
    @ConditionalOnMissingBean
    public Retryer feignRetryer() {
        return Retryer.NEVER_RETRY;
    }

    @Bean(name={"tenantFeignClient"})
    public feign.okhttp.OkHttpClient tenantClient(OkHttpClient okHttpClient) {
        feign.okhttp.OkHttpClient client = new feign.okhttp.OkHttpClient(okHttpClient);
        return client;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public Feign.Builder feignBuilder(Retryer retryer, @Qualifier(value="tenantOkHttpClient") OkHttpClient tenantOkHttpClient) {
        return Feign.builder().retryer(retryer).client((Client)new feign.okhttp.OkHttpClient(tenantOkHttpClient));
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.auth.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(value={"tenantClientService"})
    public ClientService clientService(@Qualifier(value="tenantRestTemplate") RestTemplate okHttpRestTemplate, OauthClientProperties oauthClientProperties) {
        return new ClientService(okHttpRestTemplate, oauthClientProperties);
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.auth.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(name={"tenantTokenRequestInterceptor"})
    public TenantTokenRequestInterceptor tenantTokenRequestInterceptor(@Qualifier(value="tenantClientService") ClientService clientService) {
        return new TenantTokenRequestInterceptor(clientService);
    }

    @Bean(name={"userContextFeignInterceptor"})
    public UserContextFeignInterceptor userContextFeignInterceptor() {
        return new UserContextFeignInterceptor();
    }

    private static /* synthetic */ void lambda$feignConversionService$1(FormattingConversionService conversionService, FeignFormatterRegistrar feignFormatterRegistrar) {
        feignFormatterRegistrar.registerFormatters((FormatterRegistry)conversionService);
    }
}

