package com.xforceplus.tenant.security.client.config;

import com.xforceplus.tenant.security.client.support.OauthClientProperties;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import feign.optionals.OptionalDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;



@AutoConfigureAfter({FeignAutoConfiguration.class})
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties({OauthClientProperties.class})
public class TenantFeignFormConfiguration extends TenantFeignConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TenantFeignFormConfiguration.class);

    public TenantFeignFormConfiguration(ObjectFactory<HttpMessageConverters> messageConverters) {
        super(messageConverters);
        logger.info("TenantFeignFormConfiguration initializing");
    }

    @Bean("tenantFeignEncoder")
    @ConditionalOnMissingBean(name = "tenantFeignEncoder")
    public Encoder feignEncoder() {
        return new SpringFormEncoder();
    }

}
