package com.xforceplus.tenant.security.client.interceptor;

import com.xforceplus.tenant.security.client.service.ClientService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.beans.factory.annotation.Value;

/**
 * @author geewit
 */
public class TenantTokenRequestInterceptor implements RequestInterceptor {
    public TenantTokenRequestInterceptor(ClientService clientService) {
        this.clientService = clientService;
    }

    private ClientService clientService;

    @Value("${xforce.tenant.security.client.header_name:x-app-token}")
    private String headerName;

    @Override
    public void apply(RequestTemplate template) {
        String token = clientService.token();
        if(token != null) {
            template.header(headerName, token);
        }
    }
}
