/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.tenant.security.client.support.OauthClientProperties;
import io.geewit.web.utils.JsonUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ClientService {
    private static final Logger logger = LoggerFactory.getLogger(ClientService.class);
    private final RestTemplate restTemplate;
    private final OauthClientProperties clientProperties;
    private final LoadingCache<String, String> cache;
    private final CacheLoader<String, String> loader = new CacheLoader<String, String>(){

        public String load(String key) {
            return ClientService.this.fetchToken();
        }
    };

    public ClientService(RestTemplate restTemplate, OauthClientProperties clientProperties) {
        this.restTemplate = restTemplate;
        this.clientProperties = clientProperties;
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(Duration.of(clientProperties.getExpireHours(), ChronoUnit.HOURS)).build(this.loader);
    }

    public String token() {
        if (this.clientProperties.getParams() == null || StringUtils.isBlank((CharSequence)this.clientProperties.getParams().getClientId())) {
            return null;
        }
        return (String)this.cache.getUnchecked((Object)this.clientProperties.getParams().getClientId());
    }

    public void refresh() {
        this.cache.invalidateAll();
    }

    private String fetchToken() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((Object)this.clientProperties.getParams(), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.clientProperties.getRequestUrl(), (Object)request, String.class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                String body = (String)responseEntity.getBody();
                Map bodyMap = (Map)JsonUtils.fromJson((String)body, (TypeReference)new TypeReference<Map<String, String>>(){});
                String token = (String)bodyMap.get("data");
                logger.info("fetch token: {}", (Object)token);
                return token;
            }
            logger.warn("request {} faild (reponse.status: {})", (Object)this.clientProperties.getRequestUrl(), (Object)responseEntity.getStatusCodeValue());
            this.refresh();
            return null;
        }
        catch (RestClientException e) {
            logger.warn(e.getMessage());
            this.refresh();
            return null;
        }
    }
}

