/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import feign.codec.EncodeException;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.data.domain.Sort;

public class SortJsonComponent {

    public static class SortDeserializer
    extends JsonDeserializer<Sort> {
        public Sort deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
            if (treeNode.isArray()) {
                ArrayNode arrayNode = (ArrayNode)treeNode;
                ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
                for (JsonNode jsonNode : arrayNode) {
                    Sort.Order order = new Sort.Order(Sort.Direction.valueOf((String)jsonNode.get("direction").textValue()), jsonNode.get("property").textValue());
                    orders.add(order);
                }
                return Sort.by(orders);
            }
            return null;
        }

        public Class<Sort> handledType() {
            return Sort.class;
        }
    }

    public static class SortSerializer
    extends JsonSerializer<Sort> {
        public void serialize(Sort value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            value.iterator().forEachRemaining(v -> {
                try {
                    gen.writeObject(v);
                }
                catch (IOException e) {
                    throw new EncodeException("Couldn't serialize object " + v);
                }
            });
            gen.writeEndArray();
        }

        public Class<Sort> handledType() {
            return Sort.class;
        }
    }
}

