/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.config;

import com.xforceplus.tenant.core.exception.TenantFeignException;
import com.xforceplus.tenant.core.exception.response.ErrorResponse;
import com.xforceplus.tenant.security.client.interceptor.TenantTokenRequestInterceptor;
import com.xforceplus.tenant.security.client.interceptor.UserContextFeignInterceptor;
import com.xforceplus.tenant.security.client.service.ClientService;
import com.xforceplus.tenant.security.client.support.OauthClientProperties;
import com.xforceplus.tenant.security.client.support.PageJacksonModule;
import com.xforceplus.tenant.security.client.support.PageableSpringEncoder;
import com.xforceplus.tenant.security.client.support.SortJacksonModule;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.FeignException;
import feign.Request;
import feign.Response;
import feign.Retryer;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.optionals.OptionalDecoder;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestTemplate;

@ConditionalOnMissingBean(value={TenantFeignConfiguration.class})
@EnableFeignClients(basePackages={"com.xforceplus"})
@AutoConfigureAfter(value={FeignAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OauthClientProperties.class, SpringDataWebProperties.class})
public class TenantFeignConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TenantFeignConfiguration.class);
    protected final ObjectFactory<HttpMessageConverters> messageConverters;
    @Autowired(required=false)
    protected List<AnnotatedParameterProcessor> parameterProcessors = new ArrayList<AnnotatedParameterProcessor>();
    @Autowired(required=false)
    protected List<FeignFormatterRegistrar> feignFormatterRegistrars = new ArrayList<FeignFormatterRegistrar>();
    @Autowired(required=false)
    protected SpringDataWebProperties springDataWebProperties;

    public TenantFeignConfiguration(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
        logger.info("TenantFeignConfiguration initialized");
    }

    @Primary
    @Bean(value={"tenantDecoder"})
    public Decoder feignDecoder() {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder((Decoder)new SpringDecoder(this.messageConverters)));
    }

    @Primary
    @Bean(value={"tenantErrorDecoder"})
    public ErrorDecoder errorDecoder() {
        return (methodKey, response) -> {
            Request request = response.request();
            if (request != null) {
                String requestUrl = request.url();
                String requestMethod = request.httpMethod().name();
                Map requestHeaders = request.headers();
                logger.error("request url:{}, method:{}, headers:{}", new Object[]{requestUrl, requestMethod, JsonUtils.toJson((Object)requestHeaders)});
                if (request.body() != null) {
                    String requestBody = new String(request.body(), StandardCharsets.UTF_8);
                    logger.error("request.body:{}", (Object)requestBody);
                }
            }
            if (response.body() != null) {
                try {
                    String responseBody = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
                    ErrorResponse errorResponse = (ErrorResponse)JsonUtils.fromJson((String)responseBody, ErrorResponse.class);
                    if (response.status() >= HttpStatus.BAD_REQUEST.value() && response.status() <= HttpStatus.INTERNAL_SERVER_ERROR.value()) {
                        logger.error("response status: {}, body: {}", (Object)response.status(), (Object)responseBody);
                        throw new TenantFeignException(errorResponse.getCode(), errorResponse.getMessage(), response.status());
                    }
                }
                catch (IOException e) {
                    logger.error("\u83b7\u53d6\u8fd4\u56de\u503c\u53d1\u751f\u9519\u8bef");
                }
            }
            return FeignException.errorStatus((String)methodKey, (Response)response);
        };
    }

    @Primary
    @Bean(value={"tenantEncoder"})
    @ConditionalOnMissingClass(value={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean(value={Encoder.class})
    public Encoder feignEncoder() {
        return new SpringEncoder(this.messageConverters);
    }

    @Primary
    @Bean(value={"tenantEncoder"})
    @ConditionalOnClass(name={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean(value={Encoder.class})
    public PageableSpringEncoder feignEncoderPageable() {
        PageableSpringEncoder encoder = new PageableSpringEncoder((Encoder)new SpringEncoder(this.messageConverters));
        if (this.springDataWebProperties != null) {
            encoder.setPageParameter(this.springDataWebProperties.getPageable().getPageParameter());
            encoder.setSizeParameter(this.springDataWebProperties.getPageable().getSizeParameter());
            encoder.setSortParameter(this.springDataWebProperties.getSort().getSortParameter());
            encoder.setOneIndexedParameters(this.springDataWebProperties.getPageable().isOneIndexedParameters());
        }
        return encoder;
    }

    @Primary
    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Page"})
    public PageJacksonModule pageJacksonModule() {
        return new PageJacksonModule();
    }

    @Primary
    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Sort"})
    public SortJacksonModule sortJacksonModule() {
        return new SortJacksonModule();
    }

    @Primary
    @Bean(value={"tenantSpringMvcContract"})
    public Contract feignContract(@Qualifier(value="tenantFormattingConversionService") ConversionService feignConversionService) {
        return new SpringMvcContract(this.parameterProcessors, feignConversionService);
    }

    @Primary
    @Bean(value={"tenantFormattingConversionService"})
    public FormattingConversionService feignConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.feignFormatterRegistrars.forEach(arg_0 -> TenantFeignConfiguration.lambda$feignConversionService$1((FormattingConversionService)conversionService, arg_0));
        return conversionService;
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean(value={Retryer.class})
    public Retryer feignRetryer() {
        return Retryer.NEVER_RETRY;
    }

    @Primary
    @Bean(name={"tenantFeignClient"})
    public feign.okhttp.OkHttpClient tenantClient(OkHttpClient okHttpClient) {
        feign.okhttp.OkHttpClient client = new feign.okhttp.OkHttpClient(okHttpClient);
        return client;
    }

    @Primary
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public Feign.Builder feignBuilder(Retryer retryer, @Qualifier(value="tenantOkHttpClient") OkHttpClient tenantOkHttpClient) {
        return Feign.builder().retryer(retryer).client((Client)new feign.okhttp.OkHttpClient(tenantOkHttpClient));
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.auth.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(value={"tenantClientService"})
    public ClientService clientService(@Qualifier(value="tenantRestTemplate") RestTemplate okHttpRestTemplate, OauthClientProperties oauthClientProperties) {
        return new ClientService(okHttpRestTemplate, oauthClientProperties);
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.auth.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(name={"tenantTokenRequestInterceptor"})
    public TenantTokenRequestInterceptor tenantTokenRequestInterceptor(@Qualifier(value="tenantClientService") ClientService clientService) {
        return new TenantTokenRequestInterceptor(clientService);
    }

    @Bean(name={"userContextFeignInterceptor"})
    public UserContextFeignInterceptor userContextFeignInterceptor() {
        return new UserContextFeignInterceptor();
    }

    private static /* synthetic */ void lambda$feignConversionService$1(FormattingConversionService conversionService, FeignFormatterRegistrar feignFormatterRegistrar) {
        feignFormatterRegistrar.registerFormatters((FormatterRegistry)conversionService);
    }
}

