package com.xforceplus.tenant.security.client.interceptor;

import com.xforceplus.tenant.security.client.service.ClientService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

/**
 * 微服务中拦截调用微服务请求，把x-app-token塞入header
 * @author geewit
 */
public class TenantTokenRequestInterceptor implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TenantTokenRequestInterceptor.class);

    public TenantTokenRequestInterceptor(ClientService clientService) {
        this.clientService = clientService;
    }

    private ClientService clientService;

    @Value("${xforce.tenant.security.client.header_name:x-app-token}")
    private String headerName;

    @Override
    public void apply(RequestTemplate template) {
        String token = clientService.token();
        if(token != null) {
            logger.info("token = " + token);
            template.header(headerName, token);
        }
    }
}
