/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.config;

import com.xforceplus.tenant.security.client.feign.config.XforceDataWebProperties;
import com.xforceplus.tenant.security.client.feign.interceptor.TenantTokenRequestInterceptor;
import com.xforceplus.tenant.security.client.feign.interceptor.UserContextFeignInterceptor;
import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.client.feign.support.OauthClientProperties;
import com.xforceplus.tenant.security.client.feign.support.PageJacksonModule;
import com.xforceplus.tenant.security.client.feign.support.PageableSpringEncoder;
import com.xforceplus.tenant.security.client.feign.support.SortJacksonModule;
import com.xforceplus.tenant.security.client.feign.utils.FeignUtils;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ResourceLoader;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.web.client.RestTemplate;

@ConditionalOnMissingBean(value={TenantFeignConfiguration.class})
@EnableFeignClients(basePackages={"com.xforceplus"})
@AutoConfigureAfter(value={FeignAutoConfiguration.class})
@Configuration(value="tenantFeignConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={OauthClientProperties.class, XforceDataWebProperties.class, SpringDataWebProperties.class, FeignClientProperties.class})
public class TenantFeignConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TenantFeignConfiguration.class);
    @Autowired(required=false)
    protected List<AnnotatedParameterProcessor> parameterProcessors = new ArrayList<AnnotatedParameterProcessor>();
    @Autowired(required=false)
    protected List<FeignFormatterRegistrar> feignFormatterRegistrars = new ArrayList<FeignFormatterRegistrar>();
    @Autowired(required=false)
    protected XforceDataWebProperties xforceDataWebProperties;
    @Autowired(required=false)
    protected SpringDataWebProperties springDataWebProperties;
    @Autowired(required=false)
    protected FeignClientProperties feignClientProperties;

    public TenantFeignConfiguration() {
        logger.info("TenantFeignConfiguration initialized");
    }

    @Primary
    @Bean(value={"tenantDecoder"})
    public Decoder feignDecoder() {
        return FeignUtils.feignDecoder();
    }

    @Primary
    @Bean(value={"tenantErrorDecoder"})
    public ErrorDecoder errorDecoder(ClientService clientService) {
        return FeignUtils.errorDecoder((ClientService)clientService);
    }

    @Primary
    @Bean(value={"tenantEncoder"})
    @ConditionalOnMissingClass(value={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean(value={Encoder.class})
    public Encoder feignEncoder() {
        return FeignUtils.feignEncoder();
    }

    @Primary
    @Bean(value={"tenantEncoder"})
    @ConditionalOnClass(name={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean(value={Encoder.class})
    public PageableSpringEncoder feignEncoderPageable() {
        String pageParameter = StringUtils.defaultString((String)this.xforceDataWebProperties.getPageable().getPageParameter(), (String)this.springDataWebProperties.getPageable().getPageParameter());
        String sizeParameter = StringUtils.defaultString((String)this.xforceDataWebProperties.getPageable().getSizeParameter(), (String)this.springDataWebProperties.getPageable().getSizeParameter());
        String sortParameter = StringUtils.defaultString((String)this.xforceDataWebProperties.getSort().getSortParameter(), (String)this.springDataWebProperties.getSort().getSortParameter());
        Boolean oneIndexedParameters = this.xforceDataWebProperties.getPageable().isOneIndexedParameters();
        return FeignUtils.feignEncoderPageable((String)pageParameter, (String)sizeParameter, (String)sortParameter, (Boolean)oneIndexedParameters);
    }

    @Primary
    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Page"})
    public PageJacksonModule pageJacksonModule() {
        return FeignUtils.pageJacksonModule();
    }

    @Primary
    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Sort"})
    public SortJacksonModule sortJacksonModule() {
        return new SortJacksonModule();
    }

    @Primary
    @Bean(value={"tenantSpringMvcContract"})
    public Contract feignContract(ResourceLoader resourceLoader, @Qualifier(value="tenantFormattingConversionService") FormattingConversionService feignConversionService) {
        return FeignUtils.feignContract((ResourceLoader)resourceLoader, this.parameterProcessors, (FormattingConversionService)feignConversionService);
    }

    @Primary
    @Bean(value={"tenantFormattingConversionService"})
    public FormattingConversionService feignConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        FeignUtils.addConverters((FormattingConversionService)conversionService);
        this.feignFormatterRegistrars.forEach(arg_0 -> TenantFeignConfiguration.lambda$feignConversionService$0((FormattingConversionService)conversionService, arg_0));
        return conversionService;
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean(value={Retryer.class})
    public Retryer feignRetryer() {
        return Retryer.NEVER_RETRY;
    }

    @Primary
    @Bean(name={"tenantFeignOkHttpClient"})
    public feign.okhttp.OkHttpClient tenantFeignOkHttpClient(@Qualifier(value="tenantOkHttpClient") OkHttpClient okHttpClient) {
        feign.okhttp.OkHttpClient client = new feign.okhttp.OkHttpClient(okHttpClient);
        return client;
    }

    @Primary
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public Feign.Builder feignBuilder(Retryer retryer, @Qualifier(value="tenantOkHttpClient") OkHttpClient tenantOkHttpClient, @Qualifier(value="tenantTokenRequestInterceptor") Optional<TenantTokenRequestInterceptor> tenantTokenRequestInterceptorOptional, @Qualifier(value="userContextFeignInterceptor") Optional<UserContextFeignInterceptor> userContextFeignInterceptorOptional) {
        Feign.Builder builder = Feign.builder();
        if (this.feignClientProperties != null) {
            FeignClientProperties.FeignClientConfiguration defaultConifg = (FeignClientProperties.FeignClientConfiguration)this.feignClientProperties.getConfig().get("default");
            builder = FeignUtils.builderOption((Feign.Builder)builder, (FeignClientProperties.FeignClientConfiguration)defaultConifg);
        }
        builder = builder.retryer(retryer).client((Client)new feign.okhttp.OkHttpClient(tenantOkHttpClient));
        Set requestInterceptors = null;
        if (tenantTokenRequestInterceptorOptional.isPresent()) {
            logger.info("tenantTokenRequestInterceptor created successfully");
            requestInterceptors = Stream.of(tenantTokenRequestInterceptorOptional.get()).collect(Collectors.toSet());
        }
        if (userContextFeignInterceptorOptional.isPresent()) {
            logger.info("userContextFeignInterceptor created successfully");
            if (requestInterceptors == null) {
                requestInterceptors = Stream.of(userContextFeignInterceptorOptional.get()).collect(Collectors.toSet());
            } else {
                requestInterceptors.add(userContextFeignInterceptorOptional.get());
            }
        }
        builder = FeignUtils.registerRequestInterceptors((Feign.Builder)builder, requestInterceptors, (RequestInterceptor[])new RequestInterceptor[0]);
        return builder;
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.auth.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(value={"tenantClientService"})
    public ClientService clientService(@Qualifier(value="tenantRestTemplate") RestTemplate tenantRestTemplate, OauthClientProperties oauthClientProperties) {
        logger.info("register ClientService");
        return new ClientService(tenantRestTemplate, oauthClientProperties);
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.auth.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(value={"tenantTokenRequestInterceptor"})
    public TenantTokenRequestInterceptor tenantTokenRequestInterceptor(@Qualifier(value="tenantClientService") Optional<ClientService> clientServiceOptional) {
        logger.info("init bean: TenantTokenRequestInterceptor");
        if (clientServiceOptional.isPresent()) {
            return new TenantTokenRequestInterceptor(clientServiceOptional.get());
        }
        throw new IllegalArgumentException("xforce.tenant.security.auth.enable = false, TenantTokenRequestInterceptor init failed.");
    }

    @ConditionalOnProperty(name={"xforce.tenant.security.user-info.enable"}, havingValue="true", matchIfMissing=true)
    @Bean(name={"userContextFeignInterceptor"})
    public UserContextFeignInterceptor userContextFeignInterceptor() {
        logger.info("init bean: UserContextFeignInterceptor");
        return new UserContextFeignInterceptor();
    }

    private static /* synthetic */ void lambda$feignConversionService$0(FormattingConversionService conversionService, FeignFormatterRegistrar feignFormatterRegistrar) {
        feignFormatterRegistrar.registerFormatters((FormatterRegistry)conversionService);
    }
}

