/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.interceptor;

import com.xforceplus.tenant.security.client.service.ClientService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.beans.factory.annotation.Value;

public class TenantTokenRequestInterceptor
implements RequestInterceptor {
    private ClientService clientService;
    @Value(value="${xforce.tenant.security.client.header_name:x-app-token}")
    private String headerName;

    public TenantTokenRequestInterceptor(ClientService clientService) {
        this.clientService = clientService;
    }

    public void apply(RequestTemplate template) {
        String token = this.clientService.token();
        if (token != null) {
            template.header(this.headerName, new String[]{token});
        }
    }
}

