/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.interceptor;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.UserType;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.geewit.web.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContextFeignInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UserContextFeignInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        IAuthorizedUser userInfo = UserInfoHolder.get();
        if (userInfo != null) {
            try {
                String value = CompressionUtils.encode((String)JsonUtils.toJson((Object)userInfo));
                requestTemplate.header(UserType.USER.userinfoKey(), new String[]{value});
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

