/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.tenant.security.client.config.OauthClientProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ClientService {
    private final RestTemplate restTemplate;
    private final OauthClientProperties clientProperties;
    private final LoadingCache<String, String> cache;
    private final CacheLoader<String, String> loader = new CacheLoader<String, String>(){

        public String load(String key) {
            return ClientService.this.fetchToken();
        }
    };

    public ClientService(RestTemplate restTemplate, OauthClientProperties clientProperties) {
        this.restTemplate = restTemplate;
        this.clientProperties = clientProperties;
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterAccess(Duration.of(clientProperties.getExpireHours(), ChronoUnit.HOURS)).build(this.loader);
    }

    public String token() {
        if (this.clientProperties.getParams() == null || StringUtils.isBlank((CharSequence)this.clientProperties.getParams().getClientId())) {
            return null;
        }
        return (String)this.cache.getUnchecked((Object)this.clientProperties.getParams().getClientId());
    }

    public void refresh() {
        this.cache.invalidateAll();
    }

    private String fetchToken() {
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.clientProperties.getRequestUrl(), (Object)this.clientProperties.getParams(), String.class, new Object[0]);
            if (HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                return (String)responseEntity.getBody();
            }
            return null;
        }
        catch (RestClientException e) {
            return null;
        }
    }
}

