package com.xforceplus.tenant.security.server.config;

import com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 自动配置spring mvc的拦截器
 * @author:      黄方
 * @since:       2019/05/13
 */
@Configuration
@ConditionalOnExpression("${xforce.tenant.security.starter.interceptors.enable:true}")
public class WebMvcInterceptorConfig implements WebMvcConfigurer {

    private UserContextInterceptor userContextInterceptor() {
        return new UserContextInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(userContextInterceptor());
    }
}
