package com.xforceplus.tenant.security.server.selectors;

import com.xforceplus.tenant.security.server.config.WebMvcInterceptorConfig;
import com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * 用于微服务中启用相关类
 *
 * @author geewit
 * @since 2019-05-13
 */
public class MvcInterceptorImportSelector implements ImportSelector {

    private Logger logger = LoggerFactory.getLogger(MvcInterceptorImportSelector.class);

    /**
     * Select and return the names of which class(es) should be imported based on
     * the {@link AnnotationMetadata} of the importing @Configuration class.
     *
     * @param importingClassMetadata
     */
    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        logger.info("--------启用用户下文--------");
        return new String[] {
                WebMvcInterceptorConfig.class.getName(),
                UserContextInterceptor.class.getName()
        };
    }
}
