/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.interceptor;

import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.tenant.security.core.annotation.NeedExtraInfo;
import com.xforceplus.tenant.security.core.annotation.WithoutAuth;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgDto;
import com.xforceplus.tenant.security.core.domain.RoleDto;
import com.xforceplus.tenant.security.core.domain.UserType;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.core.utils.RequestUtils;
import com.xforceplus.tenant.security.server.service.AuthorizedUserService;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class UserContextInterceptor
implements HandlerInterceptor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(UserContextInterceptor.class);
    @Value(value="${xforce.tenant_security.starter.interceptors.default_user_info:}")
    private String defaultUserInfoJson;
    @Value(value="${xforce.tenant.security.appid:}")
    private String appid;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String deCompressedUserInfo;
        if (handler instanceof ResourceHttpRequestHandler) {
            logger.info("handler instanceof ResourceHttpRequestHandler");
            return true;
        }
        boolean isStaticPage = RequestUtils.isStaticPage((String)request.getRequestURI());
        logger.info("isStaticPage: " + isStaticPage);
        if (isStaticPage) {
            return true;
        }
        String userinfo = request.getHeader(UserType.USER.userinfoKey());
        logger.info("header.userinfo: " + userinfo);
        HandlerMethod method = (HandlerMethod)handler;
        if (StringUtils.isEmpty((CharSequence)userinfo)) {
            boolean isWithoutAuth = method.hasMethodAnnotation(WithoutAuth.class);
            if (isWithoutAuth || StringUtils.isEmpty((CharSequence)this.defaultUserInfoJson)) {
                return true;
            }
            deCompressedUserInfo = this.defaultUserInfoJson;
            userinfo = CompressionUtils.encode((String)this.defaultUserInfoJson);
        } else {
            try {
                deCompressedUserInfo = CompressionUtils.decode((String)userinfo);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                return false;
            }
        }
        logger.info("deCompressedUserInfo:" + deCompressedUserInfo);
        try {
            if (StringUtils.isNotEmpty((CharSequence)deCompressedUserInfo)) {
                return this.setUserInfoHolder(userinfo, deCompressedUserInfo, method);
            }
            logger.warn("deCompressedUserInfo == null");
            return true;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private <O extends OrgDto<O>, R extends RoleDto> boolean setUserInfoHolder(String userinfo, String deCompressedUserInfo, HandlerMethod method) {
        AuthorizedUser userInfo;
        logger.info("userinfo = " + userinfo);
        try {
            userInfo = (AuthorizedUser)JsonUtils.fromJson((String)deCompressedUserInfo, AuthorizedUser.class);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return true;
        }
        NeedExtraInfo needExtraInfo = (NeedExtraInfo)method.getMethodAnnotation(NeedExtraInfo.class);
        if (needExtraInfo != null) {
            try {
                int appId = Integer.parseInt(this.appid);
                logger.info("appId:" + appId);
            }
            catch (NumberFormatException e) {
                logger.warn("\u672a\u8bbe\u7f6eappid");
                return false;
            }
            EnumSet<ExtraInfo> extraInfoEnumSet = EnumSet.noneOf(ExtraInfo.class);
            if (needExtraInfo.orgs()) {
                extraInfoEnumSet.add(ExtraInfo.orgs);
            }
            if (needExtraInfo.companies()) {
                extraInfoEnumSet.add(ExtraInfo.companies);
            }
            if (needExtraInfo.resources()) {
                extraInfoEnumSet.add(ExtraInfo.resources);
            }
            if (needExtraInfo.currentOrgs()) {
                extraInfoEnumSet.add(ExtraInfo.currentOrgs);
            }
            if (needExtraInfo.parentCompanies()) {
                extraInfoEnumSet.add(ExtraInfo.parentCompanies);
            }
            int extraInfoDimension = BinaryUtils.toBinary(extraInfoEnumSet);
            AuthorizedUserService authorizedUserService = (AuthorizedUserService)this.applicationContext.getBean(AuthorizedUserService.class);
            userInfo = authorizedUserService.userInfo(userInfo, extraInfoDimension);
        }
        UserInfoHolder.put((IAuthorizedUser)userInfo);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
    }
}

