/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.interceptor;

import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.tenant.security.core.annotation.NeedExtraInfo;
import com.xforceplus.tenant.security.core.annotation.WithoutAuth;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.core.utils.RequestUtils;
import com.xforceplus.tenant.security.server.service.AuthorizedService;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class UserContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UserContextInterceptor.class);
    private ApplicationContext applicationContext;

    public UserContextInterceptor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String deCompressedUserInfo;
        if (handler instanceof ResourceHttpRequestHandler) {
            logger.debug("starter handler instanceof ResourceHttpRequestHandler");
            return true;
        }
        boolean isStaticPage = RequestUtils.isStaticPage((String)request.getRequestURI());
        logger.debug("starter isStaticPage: " + isStaticPage);
        if (isStaticPage) {
            return true;
        }
        String userinfo = request.getHeader(UserType.USER.userinfoKey());
        logger.debug("starter header.userinfo: " + userinfo);
        HandlerMethod method = (HandlerMethod)handler;
        if (StringUtils.isEmpty((CharSequence)userinfo)) {
            boolean isWithoutAuth = method.hasMethodAnnotation(WithoutAuth.class);
            String defaultUserInfoJson = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.starter.interceptors.default_user_info");
            if (isWithoutAuth || StringUtils.isEmpty((CharSequence)defaultUserInfoJson)) {
                return true;
            }
            deCompressedUserInfo = defaultUserInfoJson;
            userinfo = CompressionUtils.encode((String)defaultUserInfoJson);
        } else {
            try {
                deCompressedUserInfo = CompressionUtils.decode((String)userinfo);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                return false;
            }
        }
        logger.debug("starter deCompressedUserInfo:" + deCompressedUserInfo);
        try {
            if (StringUtils.isNotEmpty((CharSequence)deCompressedUserInfo)) {
                return this.setUserInfoHolder(userinfo, deCompressedUserInfo, method);
            }
            logger.debug("starter deCompressedUserInfo == null");
            return true;
        }
        catch (Exception e) {
            logger.error("starter \u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private <R extends TokenRole, O extends OrgDto<O, E>, RR extends RoleDto, E extends OrgExtensionDto> boolean setUserInfoHolder(String userinfo, String deCompressedUserInfo, HandlerMethod method) {
        NeedExtraInfo needExtraInfo;
        TokenUser tokenUser;
        logger.debug("starter userinfo = " + userinfo);
        AuthorizedUser authorizedUser = new AuthorizedUser();
        try {
            tokenUser = (TokenUser)JsonUtils.fromJson((String)deCompressedUserInfo, TokenUser.class);
            BeanUtils.copyProperties((Object)tokenUser, (Object)authorizedUser);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return true;
        }
        if (!tokenUser.isMock() && (needExtraInfo = (NeedExtraInfo)method.getMethodAnnotation(NeedExtraInfo.class)) != null) {
            int extraInfoDimension;
            String appidPorp = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.appid");
            try {
                int appId = Integer.parseInt(appidPorp);
                logger.debug("starter appId:" + appId);
            }
            catch (NumberFormatException e) {
                logger.warn("starter\u672a\u8bbe\u7f6eappid(" + appidPorp + ")");
                return false;
            }
            EnumSet<ExtraInfo> extraInfoEnumSet = EnumSet.noneOf(ExtraInfo.class);
            if (needExtraInfo.orgs()) {
                extraInfoEnumSet.add(ExtraInfo.orgs);
            }
            if (needExtraInfo.companies()) {
                extraInfoEnumSet.add(ExtraInfo.companies);
            }
            if (needExtraInfo.resources()) {
                extraInfoEnumSet.add(ExtraInfo.resources);
            }
            if (needExtraInfo.currentOrgs()) {
                extraInfoEnumSet.add(ExtraInfo.currentOrgs);
            }
            if (needExtraInfo.parentCompanies()) {
                extraInfoEnumSet.add(ExtraInfo.parentCompanies);
            }
            if ((extraInfoDimension = BinaryUtils.toBinary(extraInfoEnumSet)) > 0) {
                AuthorizedService authorizedUserService = (AuthorizedService)this.applicationContext.getBean(AuthorizedService.class);
                authorizedUser = authorizedUserService.userInfo(authorizedUser, extraInfoDimension);
            }
        }
        UserInfoHolder.put((IAuthorizedUser)authorizedUser);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
    }
}

