/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.config;

import com.xforceplus.tenant.security.client.config.TenantFeignConfiguration;
import com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfigureAfter(value={TenantFeignConfiguration.class})
@Configuration
@ConditionalOnExpression(value="${xforce.tenant.security.starter.interceptors.enable:true}")
public class WebMvcInterceptorConfig
implements WebMvcConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcInterceptorConfig.class);

    public WebMvcInterceptorConfig() {
        logger.info("WebMvcInterceptorConfig initialized");
    }

    private UserContextInterceptor userContextInterceptor() {
        logger.info("init bean:UserContextInterceptor");
        return new UserContextInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        logger.info("registry interceptor:UserContextInterceptor");
        registry.addInterceptor((HandlerInterceptor)this.userContextInterceptor());
    }
}

