/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.starter.webflux.filter;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.core.utils.RequestUtils;
import com.xforceplus.tenant.security.starter.core.UserInfoHolderUtils;
import com.xforceplus.tenant.security.starter.webflux.adapter.RequestTokenUtils;
import com.xforceplus.tenant.security.token.decoder.JwtDecoder;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.filter.OrderedWebFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class TenantUserContextFilter
implements OrderedWebFilter {
    private static final Logger logger = LoggerFactory.getLogger(TenantUserContextFilter.class);
    public static final int DEFAULT_ORDER = -10000;
    private int order = -10000;
    private ApplicationContext applicationContext;

    public TenantUserContextFilter(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String deCompressedUserInfo;
        List headers;
        ServerHttpRequest request = exchange.getRequest();
        String requestURI = request.getURI().toString();
        boolean isStaticPage = RequestUtils.isStaticPage((String)requestURI);
        logger.debug("starter isStaticPage: " + isStaticPage);
        if (isStaticPage) {
            return this.result(exchange, chain, true);
        }
        if (logger.isDebugEnabled() && (headers = request.getHeaders().get((Object)UserType.USER.userinfoKey())) != null) {
            for (String header : headers) {
                logger.debug("starter all header.userinfos: {}", (Object)header);
            }
        }
        Boolean tokenDecode = (Boolean)this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.starter.token.decode.enable", Boolean.class, (Object)false);
        logger.info("tokenDecode: {}", (Object)tokenDecode);
        String userinfo = null;
        if (tokenDecode.booleanValue()) {
            String token = RequestTokenUtils.getToken(request);
            if (StringUtils.isBlank((CharSequence)token)) {
                String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
                logger.warn("token isBlank, " + message);
                return this.result(exchange, chain, true);
            }
            String secret = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.jwt.secret", "my_sessionjw_tsecret_xdfdffdsdfdfs_fat");
            userinfo = JwtDecoder.parseUserInfoFromToken((String)token, (String)secret);
            logger.debug("starter userinfo from token: " + userinfo);
        } else {
            List userinfos = request.getHeaders().get((Object)UserType.USER.userinfoKey());
            if (userinfos != null && !userinfos.isEmpty()) {
                userinfo = userinfos.stream().filter(StringUtils::isNotBlank).findFirst().orElse(null);
            }
            logger.debug("starter userinfo from header: " + userinfo);
        }
        if (StringUtils.isEmpty((CharSequence)userinfo)) {
            String defaultUserInfoJson = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.starter.interceptors.default_user_info");
            logger.info("defaultUserInfoJson = " + defaultUserInfoJson);
            if (StringUtils.isEmpty((CharSequence)defaultUserInfoJson)) {
                return this.result(exchange, chain, true);
            }
            deCompressedUserInfo = defaultUserInfoJson;
            userinfo = CompressionUtils.encode((String)defaultUserInfoJson);
        } else {
            try {
                deCompressedUserInfo = CompressionUtils.decode((String)userinfo);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                return this.result(exchange, chain, false);
            }
        }
        logger.debug("starter deCompressedUserInfo:" + deCompressedUserInfo);
        try {
            if (StringUtils.isNotEmpty((CharSequence)deCompressedUserInfo)) {
                RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(StringUtils.uncapitalize((String)RequestMappingHandlerMapping.class.getSimpleName()), RequestMappingHandlerMapping.class);
                HandlerMethod handlerMethod = (HandlerMethod)handlerMapping.getHandler(exchange).toProcessor().peek();
                if (handlerMethod == null) {
                    logger.warn("HandlerMethod == null");
                }
                boolean result = UserInfoHolderUtils.setUserInfoHolder((ApplicationContext)this.applicationContext, (String)userinfo, (String)deCompressedUserInfo, (HandlerMethod)handlerMethod);
                return this.result(exchange, chain, result);
            }
            logger.debug("starter deCompressedUserInfo == null");
            return chain.filter(exchange);
        }
        catch (Exception e) {
            logger.error("starter \u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return this.result(exchange, chain, false);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    Mono<Void> result(ServerWebExchange exchange, WebFilterChain chain, boolean result) {
        Mono mono = result ? chain.filter(exchange) : Mono.empty();
        return mono.transformDeferred(this::clearHolder);
    }

    private Publisher<Void> clearHolder(Mono<Void> call) {
        return call.doFinally(done -> UserInfoHolder.clearContext());
    }
}

