/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xforceplus.tenant.security.token.domain.IRole;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface ITokenUser<R extends IRole>
extends Serializable {
    @ApiModelProperty(value="\u7528\u6237ID")
    public Long getId();

    @ApiModelProperty(value="\u79df\u6237ID")
    public Long getTenantId();

    @ApiModelProperty(value="\u767b\u5f55\u8d26\u53f7id")
    public Long getAccountId();

    @ApiModelProperty(value="\u7528\u6237code")
    public String getUserCode();

    @ApiModelProperty(value="\u79df\u6237id\u96c6\u5408")
    public Set<Long> getTenantIds();

    @ApiModelProperty(value="\u79df\u6237\u7f16\u7801")
    public String getTenantCode();

    @ApiModelProperty(value="\u79df\u6237\u540d\u79f0")
    public String getTenantName();

    @ApiModelProperty(value="\u767b\u5f55\u7528\u6237\u540d")
    public String getUsername();

    @ApiModelProperty(value="\u624b\u673a")
    public String getMobile();

    @ApiModelProperty(value="\u90ae\u7bb1")
    public String getEmail();

    @ApiModelProperty(value="\u7528\u6237\u540d\u79f0")
    public String getUserName();

    @JsonIgnore
    @ApiModelProperty(value="jwt token")
    public String token();

    @ApiModelProperty(value="\u7528\u6237\u89d2\u8272\u96c6\u5408")
    public Set<R> getRoles();

    @ApiModelProperty(value="\u767b\u5f55id")
    public String getLoginId();

    @ApiModelProperty(value="\u6a21\u5757\u540d\u79f0")
    public String getModules();

    @ApiModelProperty(value="\u7528\u6237\u8d44\u6e90\u7801\u96c6\u5408")
    public Set<String> getResourceCodes();

    @ApiModelProperty(value="\u662f\u5426\u662f\u8d85\u7ea7\u7ba1\u7406\u5458")
    default public boolean isAdmin() {
        if (this.getRoles() == null || this.getRoles().isEmpty()) {
            return false;
        }
        return this.getRoles().stream().anyMatch(role -> role.getId() != null && role.getId() == 1L);
    }

    @ApiModelProperty(value="\u662f\u5426\u662f\u6a21\u62df\u8d26\u53f7")
    default public boolean isMock() {
        return StringUtils.isNotBlank((CharSequence)this.getLoginId()) && this.getLoginId().trim().startsWith("mock_");
    }
}

