/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.token.jackson.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class TokenUserSerializer<U extends TokenUser<R>, R extends TokenRole>
extends JsonSerializer<U> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public TokenUserSerializer() {
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS});
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    }

    public void serialize(U value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        if (((TokenUser)value).getId() != null) {
            generator.writeFieldName("id");
            generator.writeString(((TokenUser)value).getId().toString());
        }
        if (((TokenUser)value).getLoginId() != null) {
            generator.writeFieldName("loginId");
            generator.writeString(((TokenUser)value).getLoginId());
        }
        if (((TokenUser)value).getTenantId() != null) {
            generator.writeFieldName("tenantId");
            generator.writeString(((TokenUser)value).getTenantId().toString());
        }
        if (((TokenUser)value).getTenantCode() != null) {
            generator.writeFieldName("tenantCode");
            generator.writeString(((TokenUser)value).getTenantCode());
        }
        if (((TokenUser)value).getTenantName() != null) {
            generator.writeFieldName("tenantName");
            generator.writeString(((TokenUser)value).getTenantName());
        }
        if (((TokenUser)value).getAccountId() != null) {
            generator.writeFieldName("accountId");
            generator.writeString(((TokenUser)value).getAccountId().toString());
        }
        if (((TokenUser)value).getUsername() != null) {
            generator.writeFieldName("username");
            generator.writeString(((TokenUser)value).getUsername());
        }
        if (((TokenUser)value).getEmail() != null) {
            generator.writeFieldName("email");
            generator.writeString(((TokenUser)value).getEmail());
        }
        if (((TokenUser)value).getMobile() != null) {
            generator.writeFieldName("mobile");
            generator.writeString(((TokenUser)value).getMobile());
        }
        if (((TokenUser)value).getUserCode() != null) {
            generator.writeFieldName("userCode");
            generator.writeString(((TokenUser)value).getUserCode());
        }
        if (((TokenUser)value).getUserName() != null) {
            generator.writeFieldName("userName");
            generator.writeString(((TokenUser)value).getUserName());
        }
        if (((TokenUser)value).getModules() != null) {
            generator.writeFieldName("modules");
            generator.writeString(((TokenUser)value).getModules());
        }
        if (((TokenUser)value).getLoginName() != null) {
            generator.writeFieldName("loginName");
            generator.writeString(((TokenUser)value).getLoginName());
        }
        if (((TokenUser)value).getRoles() != null) {
            generator.writeFieldName("roles");
            generator.writeRawValue(this.objectMapper.writerWithView(provider.getActiveView()).writeValueAsString(((TokenUser)value).getRoles()));
        }
        if (StringUtils.isNotBlank((CharSequence)((TokenUser)value).getClientId())) {
            generator.writeFieldName("clientId");
            generator.writeString(((TokenUser)value).getClientId());
        }
        generator.writeEndObject();
    }
}

