package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.jpa.converter.GrantTypeConverter;
import com.xforceplus.jpa.listener.ClientListener;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.geewit.oltu.oauth2.common.message.types.GrantType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@EntityListeners({ClientListener.class})
@Entity
@Table(name = "bss_client")
@Setter
public class Client implements Serializable {

    /**
     * 物理主键
     */
    private Long id;

    @JsonView(TokenView.class)
    @ApiModelProperty("clientId")
    private String clientId;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("secret")
    private String secret;

    @JsonView(TokenView.class)
    @ApiModelProperty("client名称")
    private String clientName;

    @JsonView(TokenView.class)
    @ApiModelProperty("appId")
    private Integer appId;

    @ApiModelProperty("scope")
    private String scope;

    @ApiModelProperty("grantType")
    private GrantType grantType;

    @ApiModelProperty("跳转地址")
    private String redirectUri;

    @JsonView(TokenView.class)
    @ApiModelProperty("扩展信息")
    private String extension;

    @ApiModelProperty("状态")
    private Boolean status;

    @ApiModelProperty("资源码检查")
    private Boolean resourceCheck;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    private Date createTime;

    @JsonView(TokenView.class)
    @ApiModelProperty("关联租户id")
    private transient List<Long> tenantIds;

    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "client_id", unique = true)
    public String getClientId() {
        return clientId;
    }

    @Basic
    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    @Basic
    @Column(name = "secret")
    public String getSecret() {
        return secret;
    }

    @Basic
    @Column(name = "client_name")
    public String getClientName() {
        return clientName;
    }

    @Basic
    @Column(name = "client_app_id")
    public Integer getAppId() {
        return appId;
    }

    @Basic
    @Column(name = "scope")
    public String getScope() {
        return scope;
    }

    @Convert(converter = GrantTypeConverter.class)
    @Column(name = "grant_type")
    public GrantType getGrantType() {
        return grantType;
    }

    @Basic
    @Column(name = "redirect_uri")
    public String getRedirectUri() {
        return redirectUri;
    }

    @Basic
    @Column(name = "extension")
    public String getExtension() {
        return extension;
    }

    @Basic
    @Column(name = "status")
    public Boolean getStatus() {
        return status;
    }

    @Basic
    @Column(name = "resource_check")
    public Boolean getResourceCheck() {
        return resourceCheck;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Transient
    public List<Long> getTenantIds() {
        return tenantIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client that = (Client) o;
        return Objects.equals(this.clientId, that.clientId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId);
    }

    @Override
    public String toString() {
        return "Client{" +
                "clientId=" + clientId +
                ", userId=" + userId +
                ", clientName=" + clientName +
                ", appId=" + appId +
                ", scope=" + scope +
                ", grantType=" + grantType +
                ", redirectUri=" + redirectUri +
                ", extension=" + extension +
                ", status=" + status +
                ", resourceCheck=" + resourceCheck +
                ", createTime=" + createTime +
                '}';
    }
}
