package com.xforceplus.entity;

import com.xforceplus.domain.client.ClientTenantRelDto;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_client_tenant_rel")
public class ClientTenantRel extends ClientTenantRelDto implements Serializable {

    @Override
    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    @Override
    @Column(name = "client_id")
    public String getClientId() {
        return clientId;
    }

    @Override
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

}
