package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.CompanyServiceRelListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.*;
import org.hibernate.envers.Audited;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;


/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyServiceRelListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode(CompanyServiceRel_.COMPANY),
                        @NamedAttributeNode(CompanyServiceRel_.TENANT),
                        @NamedAttributeNode(CompanyServiceRel_.SERVICE_PACKAGE)
                }
        ),
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_COMPANY,
                attributeNodes = {
                        @NamedAttributeNode(CompanyServiceRel_.COMPANY)
                }
        ),
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_TENANT,
                attributeNodes = {
                        @NamedAttributeNode(CompanyServiceRel_.TENANT)
                }
        ),
        @NamedEntityGraph(name = CompanyServiceRel.NAMED_ENTITY_GRAPH_SERVICE_PACKAGE,
                attributeNodes = {
                        @NamedAttributeNode(CompanyServiceRel_.SERVICE_PACKAGE)
                }
        )
})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_company_service_rel")
public class CompanyServiceRel implements Serializable {

    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "CompanyServiceRel.graph";
    public static final String NAMED_ENTITY_GRAPH_COMPANY = "CompanyServiceRel.graph.company";
    public static final String NAMED_ENTITY_GRAPH_TENANT = "CompanyServiceRel.graph.tenant";
    public static final String NAMED_ENTITY_GRAPH_SERVICE_PACKAGE = "CompanyServiceRel.graph.service-package";

    public static final int STATES_ENABLE = 1;

    public static final int STATES_DISABLE = 0;

    private Long id;

    private Long tenantId;

    private Long companyId;

    private Long servicePackageId;

    private String remarks;

    private Integer status;

    private String operateReason;

    private String createId;

    private Date createTime;

    private String createUserName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonIgnore
    private Tenant tenant;

    @JsonIgnore
    private Company company;

    @JsonIgnore
    private ServicePackage servicePackage;


    private String appName;

    private String tenantCode;
    private String tenantName;

    private String taxNum;
    private String companyName;

    private String servicePackageCode;
    private String servicePackageName;


    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Audited
    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return (tenantId != null && tenantId > 0) ? tenantId : null;
    }

    @Audited
    @Basic
    @Column(name = "company_id", nullable = false)
    public Long getCompanyId() {
        return (companyId != null && companyId > 0) ? companyId : null;
    }

    @Audited
    @Basic
    @Column(name = "service_package_id", nullable = false)
    public Long getServicePackageId() {
        return (servicePackageId != null && servicePackageId > 0) ? servicePackageId : null;
    }

    @Basic
    @Column(name = "remarks")
    public String getRemarks() {
        return remarks;
    }

    @Audited
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Basic
    @Column(name = "operate_reason")
    public String getOperateReason() {
        return operateReason;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "company_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Company getCompany() {
        return company;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "service_package_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public ServicePackage getServicePackage() {
        return servicePackage;
    }

    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreateId() {
        return createId;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreateUserName() {
        return createUserName;
    }

    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }



    @Transient
    public String getTenantCode() {
        return tenantCode;
    }

    @Transient
    public String getTaxNum() {
        return taxNum;
    }

    @Transient
    public String getServicePackageCode() {
        return servicePackageCode;
    }

    @Transient
    public String getTenantName() {
        return tenantName;
    }

    @Transient
    public String getCompanyName() {
        return companyName;
    }

    @Transient
    public String getServicePackageName() {
        return servicePackageName;
    }

    @Transient
    public String getAppName() {
        return appName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompanyServiceRel)) {
            return false;
        }
        CompanyServiceRel that = (CompanyServiceRel) o;
        if (id == null) {
            if (that.id != null) {
                return false;
            } else {
                return Objects.equals(tenantId, that.tenantId) &&
                        Objects.equals(companyId, that.companyId) &&
                        Objects.equals(servicePackageId, that.servicePackageId);
            }
        } else {
            return id.equals(that.id);
        }
    }

    @Override
    public int hashCode() {
        if (this.id != null) {
            return Objects.hash(this.id);
        }
        return Objects.hash(this.tenantId, this.companyId, this.servicePackageId);
    }
}
