/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ImportFile.java   2020-09-23 17-17-59
 * Author: Evan
 */
package com.xforceplus.entity;

import com.xforceplus.annotations.Trail;
import com.xforceplus.jpa.listener.ExcelFileStorePersistenceListener;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-23 17-17-59
 * @since V1.0
 */
@SuppressWarnings("all")
@EntityListeners({ExcelFileStorePersistenceListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_import_file")
@Trail(enable = false)
@Setter
public class ExcelFileStore implements IOperator {
    /**
     * 文件导入ID
     */
    private Long id;
    /**
     * 导入租户ID
     */
    private Long tenantId;
    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 导出或入导出类型
     */
    private Integer excelFileType;
    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 处理开始时间
     */
    private Date beginDate;
    /**
     * 处理结束时间
     */
    private Date endDate;

    /**
     * 处理状态：1 未处理，2处理中，3 处理完成
     */
    private Integer status;

    /**
     * 处理耗时
     */
    private Long costTime;

    /**
     * 消息写
     */
    private String message;

    /**
     * 总记录
     */
    private Integer totalSize;

    /**
     * 成功记录数
     */
    private Integer successSize;

    /**
     * 查询参数
     */
    private String params;

    /**
     * 读取次数 默认值为0
     */
    private Integer readTime;
    /**
     * 处理结果（0 待处理 2-失败，1 成功,2 部分成功）
     */
    private Integer resultState;
    /**
     * 源文件fileId
     */
    private Long sourceFileId;
    /**
     * 目标文件fileId; (即错误文件，写入Error文件)
     */
    private Long targetFileId;

    /**
     * sourceFileName
     */
    private String sourceFileName;

    /**
     * targetFileName
     */
    private String targetFileName;

    /**
     * 每批处理的数据，默认为：3000
     */
    private Integer batchSize;

    /**
     * 创建人ID
     */
    private String createrId;

    /**
     * 更新人名称
     */
    private String createrName;

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private String updaterId;
    /**
     * 更新人名称
     */
    private String updaterName;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 乐观锁 (用来控制)
     */
    private Integer counter;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @Basic
    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    @Basic
    @Column(name = "excel_file_type")
    public Integer getExcelFileType() {
        return excelFileType;
    }

    @Basic
    @Column(name = "business_type")
    public String getBusinessType() {
        return businessType;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "begin_date")
    public Date getBeginDate() {
        return beginDate;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "end_date")
    public Date getEndDate() {
        return endDate;
    }

    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Basic
    @Column(name = "cost_time")
    public Long getCostTime() {
        return costTime;
    }

    @Basic
    @Column(name = "message")
    public String getMessage() {
        return message;
    }

    @Basic
    @Column(name = "total_size")
    public Integer getTotalSize() {
        return totalSize;
    }

    @Basic
    @Column(name = "success_size")
    public Integer getSuccessSize() {
        return successSize;
    }

    @Basic
    @Column(name = "query_params")
    public String getParams() {
        return params;
    }

    @Basic
    @Column(name = "read_time")
    public Integer getReadTime() {
        return readTime;
    }

    @Basic
    @Column(name = "result_state")
    public Integer getResultState() {
        return resultState;
    }

    @Basic
    @Column(name = "source_file_id")
    public Long getSourceFileId() {
        return sourceFileId;
    }

    @Basic
    @Column(name = "target_file_id")
    public Long getTargetFileId() {
        return targetFileId;
    }

    @Basic
    @Column(name = "source_file_name")
    public String getSourceFileName() {
        return sourceFileName;
    }

    @Basic
    @Column(name = "target_file_name")
    public String getTargetFileName() {
        return targetFileName;
    }

    @Basic
    @Column(name = "batch_size")
    public Integer getBatchSize() {
        return batchSize;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Version
    @Column(name = "opt_counter")
    public Integer getCounter() {
        return counter;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ExcelFileStore{");
        sb.append("id=").append(id);
        sb.append(", tenantId=").append(tenantId);
        sb.append(", userId=").append(userId);
        sb.append(", excelFileType=").append(excelFileType);
        sb.append(", businessType='").append(businessType).append('\'');
        sb.append(", beginDate=").append(beginDate);
        sb.append(", endDate=").append(endDate);
        sb.append(", status=").append(status);
        sb.append(", costTime=").append(costTime);
        sb.append(", message='").append(message).append('\'');
        sb.append(", totalSize=").append(totalSize);
        sb.append(", successSize=").append(successSize);
        sb.append(", params='").append(params).append('\'');
        sb.append(", readTime=").append(readTime);
        sb.append(", resultState=").append(resultState);
        sb.append(", sourceFileId=").append(sourceFileId);
        sb.append(", targetFileId=").append(targetFileId);
        sb.append(", sourceFileName='").append(sourceFileName).append('\'');
        sb.append(", targetFileName='").append(targetFileName).append('\'');
        sb.append(", batchSize=").append(batchSize);
        sb.append(", createrId='").append(createrId).append('\'');
        sb.append(", createrName='").append(createrName).append('\'');
        sb.append(", createTime=").append(createTime);
        sb.append(", updaterId='").append(updaterId).append('\'');
        sb.append(", updaterName='").append(updaterName).append('\'');
        sb.append(", updateTime=").append(updateTime);
        sb.append(", counter=").append(counter);
        sb.append('}');
        return sb.toString();
    }
}