package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.annotations.Trail;
import com.xforceplus.domain.account.LoginLogDto;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author duanhy
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_login_log")
@Trail(enable = false)
public class LoginLog extends LoginLogDto implements Serializable {
    @Override
    @Id
    @Column(name = "id", nullable = false, updatable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @ApiModelProperty("租户id")
    @Basic
    @Column(name = "tenant_id", updatable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @ApiModelProperty("账号id")
    @Basic
    @Column(name = "account_id", updatable = false)
    public Long getAccountId() {
        return accountId;
    }

    @Override
    @ApiModelProperty("用户id")
    @Basic
    @Column(name = "user_id", updatable = false)
    public Long getUserId() {
        return userId;
    }

    @Override
    @ApiModelProperty("登录账号")
    @Basic
    @Column(name = "login_name", updatable = false)
    public String getLoginName() {
        return loginName;
    }


    @Override
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "login_time", updatable = false)
    public Date getLoginTime() {
        return loginTime;
    }


}
