package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_companyno")
public class OrgCompanyNo implements Serializable {
    public OrgCompanyNo() {
    }

    public OrgCompanyNo(Long orgStructId, String companyNo) {
        this.orgStructId = orgStructId;
        this.companyNo = companyNo;
    }

    private Long id;
    private Long orgStructId;
    private String companyNo;

    @JsonIgnore
    private OrgStruct org;

    /**
     * 组织名称
     */
    private transient String orgName;
    /**
     * 组织代码
     */
    private transient String orgCode;
    /**
     * 租户Id
     */
    private transient Long tenantId;
    /**
     * 公司Id
     */
    private transient Long companyId;
    /**
     * 公司名称
     */
    private transient String companyName;
    /**
     * 公司代码
     */
    private transient String companyCode;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgStructId() {
        return orgStructId;
    }

    @Basic
    @Column(name = "company_no", nullable = false)
    public String getCompanyNo() {
        return companyNo;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_struct_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public OrgStruct getOrg() {
        return org;
    }

    @Transient
    public String getOrgName() {
        return orgName;
    }

    @Transient
    public String getOrgCode() {
        return orgCode;
    }

    @Transient
    public Long getTenantId() {
        return tenantId;
    }

    @Transient
    public Long getCompanyId() {
        return companyId;
    }

    @Transient
    public String getCompanyName() {
        return companyName;
    }

    @Transient
    public String getCompanyCode() {
        return companyCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        OrgCompanyNo that = (OrgCompanyNo) o;

        if (!getOrgStructId().equals(that.getOrgStructId())) {
            return false;
        }
        return this.companyNo.equals(that.companyNo);
    }

    @Override
    public int hashCode() {
        int result = this.orgStructId.hashCode();
        result = 31 * result + this.companyNo.hashCode();
        return result;
    }
}
