package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.jpa.listener.OrgExtensionListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({OrgExtensionListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = OrgExtension.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode(value = "org", subgraph = OrgExtension.NAMED_ENTITY_SUBGRAPH_DEFAULT)
                },
                subgraphs = {
                        @NamedSubgraph(name = OrgExtension.NAMED_ENTITY_SUBGRAPH_DEFAULT, attributeNodes = @NamedAttributeNode("tenant"))
                }
        )
})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "org_extension")
public class OrgExtension extends OrgExtensionDto implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "OrgExtension.graph";
    public static final String NAMED_ENTITY_SUBGRAPH_DEFAULT = "OrgExtension.subgraph.tenant";

    private Long orgExtensionId;

    @JsonIgnore
    private OrgStruct org;

    @Id
    @Column(name = "org_extension_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getOrgExtensionId() {
        return orgExtensionId;
    }

    @Override
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgStructId() {
        return super.getOrgStructId();
    }

    @Override
    @Basic
    @Column(name = "extension_key", nullable = false)
    public String getExtensionKey() {
        return super.getExtensionKey();
    }

    @Override
    @Basic
    @Column(name = "extension_value", nullable = false)
    public String getExtensionValue() {
        return super.getExtensionValue();
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_struct_id", referencedColumnName = "org_struct_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public OrgStruct getOrg() {
        return org;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantName() {
        return super.tenantName;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantCode() {
        return super.tenantCode;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getOrgName() {
        return super.orgName;
    }

    @Transient
    public void postLoad() {
        if (this.org != null) {
            this.orgName = this.org.getOrgName();
            Tenant tenant = this.org.getTenant();
            if (tenant != null && tenant.getCreateTime() != null) {
                this.tenantName = tenant.getTenantName();
                this.tenantCode = tenant.getTenantCode();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
