package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.user.OrgUserDTO;
import com.xforceplus.jpa.listener.OrgListener;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import io.geewit.core.jackson.view.View;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * 组织机构
 *
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({OrgListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = OrgStruct.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode(OrgStruct_.COMPANY),
                        @NamedAttributeNode(OrgStruct_.TENANT),
                        @NamedAttributeNode(OrgStruct_.ORG_STRUCT_TYPE)
                }
        ),
        @NamedEntityGraph(name = OrgStruct.NAMED_ENTITY_GRAPH_TENANT,
                attributeNodes = {
                        @NamedAttributeNode(OrgStruct_.TENANT),
                        @NamedAttributeNode(OrgStruct_.ORG_STRUCT_TYPE)
                }
        ),
        @NamedEntityGraph(name = OrgStruct.NAMED_ENTITY_GRAPH_COMPANY,
                attributeNodes = {
                        @NamedAttributeNode(OrgStruct_.COMPANY),
                        @NamedAttributeNode(OrgStruct_.ORG_STRUCT_TYPE)
                }
        ),
        @NamedEntityGraph(name = OrgStruct.NAMED_ENTITY_GRAPH_FULL,
                attributeNodes = {
                        @NamedAttributeNode(OrgStruct_.COMPANY),
                        @NamedAttributeNode(OrgStruct_.TENANT),
                        @NamedAttributeNode(OrgStruct_.ORG_COMPANY_NOS),
                        @NamedAttributeNode(OrgStruct_.ORG_STRUCT_TYPE)
                }
        )
})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_struct")
public class OrgStruct extends OrgDto<OrgStruct> implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "Org.graph";
    public static final String NAMED_ENTITY_GRAPH_COMPANY = "Org.graph.company";
    public static final String NAMED_ENTITY_GRAPH_TENANT = "Org.graph.tenant";
    public static final String NAMED_ENTITY_GRAPH_FULL = "Org.graph.full";

    @JsonView(OrgView.OrgInfo.class)
    private Company company;

    @JsonView(OrgView.OrgInfo.class)
    private Tenant tenant;

    @JsonView(OrgView.OrgInfo.class)
    private List<ServicePackage> packages;

    @JsonIgnore
    private List<OrgUserRel> orgUserRels;

    @JsonIgnore
    private List<RoleOrgRel> roleOrgRels;

    @JsonIgnore
    private List<OrgCompanyNo> orgCompanyNos;

    @JsonView(OrgView.OrgInfo.class)
    private OrgType orgStructType;

    @Override
    @Id
    @Column(name = "org_struct_id", nullable = false)
    @Basic
    public Long getOrgId() {
        return super.id;
    }

    @Override
    public void setOrgId(Long orgId) {
        super.id = orgId;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return this.tenantId;
    }

    @Override
    @Basic
    @Column(name = "company_id")
    public Long getCompanyId() {
        return this.companyId;
    }

    @Override
    @Basic
    @Column(name = "org_code", nullable = false)
    public String getOrgCode() {
        return orgCode;
    }

    @Override
    @Basic
    @Column(name = "org_name", nullable = false)
    public String getOrgName() {
        return orgName;
    }

    @Override
    @Basic
    @Column(name = "parent_ids", nullable = false)
    public String getParentIds() {
        return parentIds;
    }

    @Override
    @Basic
    @Column(name = "parent_id")
    public Long getParentId() {
        return parentId;
    }

    @Override
    public void setParentId(Long parentId) {
        super.parentId = parentId;
    }

    @Override
    @Column(name = "org_type", nullable = false)
    @Basic
    public String getOrgType() {
        return orgType;
    }

    @Override
    @Basic
    @Column(name = "org_biz_type")
    public String getOrgBizType() {
        return orgBizType;
    }

    @Override
    @Basic
    @Column(name = "org_desc", nullable = false)
    public String getOrgDesc() {
        return orgDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "audit_status")
    public Integer getAuditStatus() {
        return auditStatus;
    }

    @Override
    @Basic
    @Column(name = "enabled_time")
    public Date getEnabledTime() {
        return enabledTime;
    }

    @Override
    @Basic
    @Column(name = "disabled_time")
    public Date getDisabledTime() {
        return disabledTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @JsonIgnore
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "org", cascade = {})
    public List<OrgCompanyNo> getOrgCompanyNos() {
        return orgCompanyNos;
    }

    @JsonView({View.List.class, OrgView.OrgInfo.class})
    @Transient
    @Override
    public Set<String> getCompanyNos() {
        return super.companyNos;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", referencedColumnName = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public Tenant getTenant() {
        return tenant;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "company_id", referencedColumnName = "company_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @NotFound(action = NotFoundAction.IGNORE)
    public Company getCompany() {
        return company;
    }

    @JsonIgnore
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "org")
    public List<OrgUserRel> getOrgUserRels() {
        return orgUserRels;
    }

    @JsonIgnore
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "org")
    public List<RoleOrgRel> getRoleOrgRels() {
        return roleOrgRels;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_type", referencedColumnName = "org_type_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public OrgType getOrgStructType() {
        return orgStructType;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getParentName() {
        return super.parentName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getCompanyName() {
        return super.companyName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getCompanyCode() {
        return super.companyCode;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getTaxNum() {
        return super.taxNum;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantName() {
        return super.tenantName;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantCode() {
        return super.tenantCode;
    }

    @JsonView(OrgView.Info.class)
    @Transient
    public List<ServicePackage> getPackages() {
        return packages;
    }

    @Override
    @JsonView(View.class)
    @Transient
    public List<OrgStruct> getParentOrgs() {
        return super.parentOrgs;
    }

    @JsonView(View.Info.class)
    @Transient
    @Override
    public OrgStruct getParent() {
        return super.parent;
    }


    @Override
    @JsonView({View.class})
    @Transient
    public List<OrgUserDTO> getOrgUsers() {
        return super.orgUsers;
    }

    @Transient
    public void postLoad() {
        if (this.tenant != null) {
            this.tenantCode = this.tenant.getTenantCode();
            this.tenantName = this.tenant.getTenantName();
        }
        if (this.company != null) {
            this.companyCode = this.company.getCompanyCode();
            this.companyName = this.company.getCompanyName();
            this.taxNum = this.company.getTaxNum();
        }
        if (this.orgCompanyNos != null) {
            super.companyNos = this.orgCompanyNos.stream()
                    .map(OrgCompanyNo::getCompanyNo)
                    .collect(Collectors.toSet());
        }
        if (this.orgStructType != null) {
            this.orgType = String.valueOf(this.orgStructType.getOrgTypeId());
            this.orgTypeName = this.orgStructType.getName();
            this.orgTypeCode = this.orgStructType.getCode();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
