package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.OrgUserRelListener;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({OrgUserRelListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_user_rel")
public class OrgUserRel implements IOperator, Serializable {
    public static final int REL_TYPE_NORMAL = 1;
    public static final int REL_TYPE_ADMIN = 2;

    private Long id;
    private Long tenantId;
    private Long orgStructId;
    private Long userId;
    /**
     * 组织身份 1: 普通, 2: 管理员
     */
    private Integer relType;
    private String createrId;
    private String createrName;
    private Date createTime;
    private String updaterId;
    private String updaterName;
    private Date updateTime;

    @JsonIgnore
    private OrgStruct org;

    @JsonIgnore
    private User user;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgStructId() {
        return (orgStructId != null && orgStructId > 0) ? orgStructId : null;
    }

    @Basic
    @Column(name = "user_id", nullable = false)
    public Long getUserId() {
        return userId;
    }

    @Basic
    @Column(name = "rel_type", nullable = false)
    public Integer getRelType() {
        return relType;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_struct_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public OrgStruct getOrg() {
        return org;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId(){
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgUserRel that = (OrgUserRel) o;
        if (id == null) {
            if (that.id != null) {
                return false;
            } else {
                return Objects.equals(orgStructId, that.orgStructId) &&
                        Objects.equals(userId, that.userId);
            }
        } else {
            return id.equals(that.id);
        }
    }

    @Override
    public int hashCode() {
        if (id != null) {
            return Objects.hash(id);
        }
        return Objects.hash(orgStructId, userId);
    }
}
