package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.annotations.Trail;
import com.xforceplus.jpa.listener.PasswordHistoryListener;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.StringJoiner;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@Setter
@EntityListeners({PasswordHistoryListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Trail(enable = false)
@Table(name = "account_password_history")
public class PasswordHistory implements Serializable {
    private String id;

    private Long accountId;

    private String password;

    private Date createTime;

    @JsonIgnore
    private Long tenantId;

    @Id
    @Column(name = "id", unique = true, nullable = false)
    public String getId() {
        return id;
    }

    @Column(name = "account_id", nullable = false)
    public Long getAccountId() {
        return accountId;
    }

    @Basic
    @Column(name = "password", nullable = false)
    public String getPassword() {
        return password;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Transient
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PasswordHistory.class.getSimpleName() + "[", "]")
                .add("id=" + id)
                .add("accountId=" + accountId)
                .add("createTime=" + createTime)
                .toString();
    }
}
