package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.*;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.jpa.listener.RoleListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;

import lombok.Setter;
import org.hibernate.annotations.*;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({RoleListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = Role.NAMED_ENTITY_GRAPH_TENANT,
                attributeNodes = {
                        @NamedAttributeNode(Role_.TENANT)
                }
        )})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role")
public class Role extends RoleDto implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_TENANT = "Role.graph.tenant";

    public static final int ROLE_TYPE_NORMAL = 1;

    public static final int ROLE_TYPE_ORG = 2;

    public static final long TENANT_ADMIN = 1L;

    @JsonIgnore
    private List<RoleResourcesetRel> roleResourcesetRels;

    @JsonIgnore
    private List<RoleUserRel> roleUserRels;

    @JsonIgnore
    private List<RoleServicePackage> roleServicePackages;

    @JsonIgnore
    private List<RoleOrgRel> roleOrgRels;

    @JsonView(View.class)
    private String appName;

    @JsonView(View.class)
    private String servicePackageName;

    @JsonView(View.class)
    private List<String> servicePackageNames;

    @JsonView(View.class)
    private List<ServicePackage> servicePackages;

    @Transient
    @JsonBackReference
    private transient User user;

    @JsonIgnore
    private Tenant tenant;

    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bindDate;

    @Override
    @Id
    @Column(name = "role_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "role_code", nullable = false)
    public String getCode() {
        return code;
    }

    @Override
    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @Basic
    @Column(name = "role_type", nullable = false)
    public Integer getType() {
        return type;
    }

    @Override
    @Basic
    @Column(name = "role_name", nullable = false)
    public String getName() {
        return name;
    }

    @Override
    @Basic
    @Column(name = "role_desc", nullable = false)
    public String getRoleDesc() {
        return roleDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @JsonIgnore
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleResourcesetRel> getRoleResourcesetRels() {
        return roleResourcesetRels;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleUserRel> getRoleUserRels() {
        return roleUserRels;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleServicePackage> getRoleServicePackages() {
        return roleServicePackages;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleOrgRel> getRoleOrgRels() {
        return roleOrgRels;
    }

    @Transient
    public String getAppName() {
        return appName;
    }

    @Transient
    public String getServicePackageName() {
        return servicePackageName;
    }

    @Transient
    public User getUser() {
        return user;
    }

    @Transient
    public Boolean getDefaultBindUser() {
        return defaultBindUser;
    }

    @Transient
    public Date getBindDate() {
        return bindDate;
    }

    @Transient
    public List<String> getServicePackageNames() {
        return servicePackageNames;
    }

    @Transient
    public List<ServicePackage> getServicePackages() {
        return servicePackages;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
